/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.http.WebSocketBase;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.WebSocket.class)
public class WebSocket
implements WebSocketBase {
    public static final TypeArg<WebSocket> __TYPE_ARG = new TypeArg(obj -> new WebSocket((io.vertx.core.http.WebSocket)obj), WebSocket::getDelegate);
    private final io.vertx.core.http.WebSocket delegate;
    private Observable<Buffer> observable;
    private Flowable<Buffer> flowable;
    private WriteStreamObserver<Buffer> observer;
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocket that = (WebSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public WebSocket(io.vertx.core.http.WebSocket delegate) {
        this.delegate = delegate;
    }

    public WebSocket(Object delegate) {
        this.delegate = (io.vertx.core.http.WebSocket)delegate;
    }

    public io.vertx.core.http.WebSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            this.observable = ObservableHelper.toObservable((ReadStream)this.getDelegate());
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<Buffer> toFlowable() {
        if (this.flowable == null) {
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.getDelegate());
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<Buffer> toObserver() {
        if (this.observer == null) {
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate());
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate());
        }
        return this.subscriber;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TypeArg.unknown());
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<Buffer> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<Buffer> dst) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.pipeTo(dst.getDelegate()));
    }

    @Override
    public Completable write(Buffer data) {
        Completable ret = this.rxWrite(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.write((Object)data));
    }

    @Override
    public Completable end(Buffer data) {
        Completable ret = this.rxEnd(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end((Object)data));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = this.delegate.headers();
        return ret;
    }

    @Override
    public Completable writeFrame(WebSocketFrame frame) {
        Completable ret = this.rxWriteFrame(frame);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteFrame(WebSocketFrame frame) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeFrame(frame));
    }

    @Override
    public Completable writeFinalTextFrame(String text) {
        Completable ret = this.rxWriteFinalTextFrame(text);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteFinalTextFrame(String text) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeFinalTextFrame(text));
    }

    @Override
    public Completable writeFinalBinaryFrame(Buffer data) {
        Completable ret = this.rxWriteFinalBinaryFrame(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteFinalBinaryFrame(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeFinalBinaryFrame(data));
    }

    @Override
    public Completable writeBinaryMessage(Buffer data) {
        Completable ret = this.rxWriteBinaryMessage(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteBinaryMessage(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeBinaryMessage(data));
    }

    @Override
    public Completable writeTextMessage(String text) {
        Completable ret = this.rxWriteTextMessage(text);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWriteTextMessage(String text) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeTextMessage(text));
    }

    @Override
    public Completable writePing(Buffer data) {
        Completable ret = this.rxWritePing(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWritePing(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writePing(data));
    }

    @Override
    public Completable writePong(Buffer data) {
        Completable ret = this.rxWritePong(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWritePong(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writePong(data));
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end());
    }

    @Override
    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    @Override
    public Completable close(short statusCode) {
        Completable ret = this.rxClose(statusCode);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose(short statusCode) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close(statusCode));
    }

    @Override
    public Completable close(short statusCode, String reason) {
        Completable ret = this.rxClose(statusCode, reason);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose(short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close(statusCode, reason));
    }

    @Override
    public Completable shutdown() {
        Completable ret = this.rxShutdown();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown());
    }

    @Override
    public Completable shutdown(short statusCode) {
        Completable ret = this.rxShutdown(statusCode);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxShutdown(short statusCode) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown(statusCode));
    }

    @Override
    public Completable shutdown(short statusCode, String reason) {
        Completable ret = this.rxShutdown(statusCode, reason);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxShutdown(short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown(statusCode, reason));
    }

    @Override
    public Completable shutdown(long timeout, TimeUnit unit) {
        Completable ret = this.rxShutdown(timeout, unit);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown(timeout, unit));
    }

    @Override
    public Completable shutdown(long timeout, TimeUnit unit, short statusCode) {
        Completable ret = this.rxShutdown(timeout, unit, statusCode);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxShutdown(long timeout, TimeUnit unit, short statusCode) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown(timeout, unit, statusCode));
    }

    @Override
    public Completable shutdown(long timeout, TimeUnit unit, short statusCode, String reason) {
        Completable ret = this.rxShutdown(timeout, unit, statusCode, reason);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxShutdown(long timeout, TimeUnit unit, short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.shutdown(timeout, unit, statusCode, reason));
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.remoteAddress();
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.localAddress();
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    @Override
    public WebSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public WebSocket handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    @Override
    public WebSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public WebSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public WebSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public WebSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public WebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public WebSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public WebSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public WebSocket shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    @Override
    public WebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler(handler);
        return this;
    }

    @Override
    public WebSocket textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocket binaryMessageHandler(Handler<Buffer> handler) {
        this.delegate.binaryMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocket pongHandler(Handler<Buffer> handler) {
        this.delegate.pongHandler(handler);
        return this;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static WebSocket newInstance(io.vertx.core.http.WebSocket arg) {
        return arg != null ? new WebSocket(arg) : null;
    }
}

