/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.net;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.net.SSLOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.core.net.NetSocket;
import io.vertx.rxjava3.core.net.SocketAddress;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements RxDelegate,
Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg(obj -> new NetClient((io.vertx.core.net.NetClient)obj), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetClient that = (NetClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public NetClient(Object delegate) {
        this.delegate = (io.vertx.core.net.NetClient)delegate;
    }

    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public Single<NetSocket> connect(int port, String host) {
        Single ret = this.rxConnect(port, host);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetSocket> rxConnect(int port, String host) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(port, host, Helper.convertHandler((Handler)connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event)))));
    }

    public Single<NetSocket> connect(int port, String host, String serverName) {
        Single ret = this.rxConnect(port, host, serverName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetSocket> rxConnect(int port, String host, String serverName) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(port, host, serverName, Helper.convertHandler((Handler)connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event)))));
    }

    public Single<NetSocket> connect(SocketAddress remoteAddress) {
        Single ret = this.rxConnect(remoteAddress);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(remoteAddress.getDelegate(), Helper.convertHandler((Handler)connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event)))));
    }

    public Single<NetSocket> connect(SocketAddress remoteAddress, String serverName) {
        Single ret = this.rxConnect(remoteAddress, serverName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress, String serverName) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(remoteAddress.getDelegate(), serverName, Helper.convertHandler((Handler)connectHandler, ar -> ar.map(event -> NetSocket.newInstance(event)))));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public Single<Boolean> updateSSLOptions(SSLOptions options) {
        Single ret = this.rxUpdateSSLOptions(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.updateSSLOptions(options, handler));
    }

    public Single<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        Single ret = this.rxUpdateSSLOptions(options, force);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.updateSSLOptions(options, force, handler));
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

