/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.redis.client;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A simple Redis client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Redis original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.Redis.class)
public class Redis implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Redis that = (Redis) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Redis> __TYPE_ARG = new TypeArg<>(    obj -> new Redis((io.vertx.redis.client.Redis) obj),
    Redis::getDelegate
  );

  private final io.vertx.redis.client.Redis delegate;
  
  public Redis(io.vertx.redis.client.Redis delegate) {
    this.delegate = delegate;
  }

  public Redis(Object delegate) {
    this.delegate = (io.vertx.redis.client.Redis)delegate;
  }

  @Override 
  public io.vertx.redis.client.Redis getDelegate() {
    return delegate;
  }

  /**
   * Create a new redis client using the default client options.
   * @param vertx the vertx instance
   * @return the client
   */
  public static io.vertx.rxjava3.redis.client.Redis createClient(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.redis.client.Redis ret = io.vertx.rxjava3.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new redis client using the default client options. Does not support rediss (redis over ssl scheme) for now.
   * @param vertx the vertx instance
   * @param connectionString a string URI following the scheme: redis://[username:password@][host][:port][/database]
   * @return the client
   */
  public static io.vertx.rxjava3.redis.client.Redis createClient(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionString) { 
    io.vertx.rxjava3.redis.client.Redis ret = io.vertx.rxjava3.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), connectionString));
    return ret;
  }

  /**
   * Create a new redis client using the given client options.
   * @param vertx the vertx instance
   * @param options the user provided options
   * @return the client
   */
  public static io.vertx.rxjava3.redis.client.Redis createClient(io.vertx.rxjava3.core.Vertx vertx, io.vertx.redis.client.RedisOptions options) { 
    io.vertx.rxjava3.redis.client.Redis ret = io.vertx.rxjava3.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)io.vertx.redis.client.Redis.createClient(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the redis server.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.redis.client.RedisConnection> connect() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.redis.client.RedisConnection> ret = rxConnect();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connects to the redis server.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.redis.client.RedisConnection> rxConnect() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.connect(io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.RedisConnection.newInstance((io.vertx.redis.client.RedisConnection)event))));
    });
  }

  /**
   * Closes the client and terminates any connection.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> send(io.vertx.rxjava3.redis.client.Request command) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSend(command);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSend(io.vertx.rxjava3.redis.client.Request command) { 
    return AsyncResultMaybe.toMaybe( onSend -> {
      delegate.send(command.getDelegate(), io.vertx.lang.rxjava3.Helper.convertHandler(onSend, ar -> ar.map(event -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    });
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.rxjava3.redis.client.Response>> batch(java.util.List<io.vertx.rxjava3.redis.client.Request> commands) { 
    io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.rxjava3.redis.client.Response>> ret = rxBatch(commands);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Single<java.util.List<io.vertx.rxjava3.redis.client.Response>> rxBatch(java.util.List<io.vertx.rxjava3.redis.client.Request> commands) { 
    return AsyncResultSingle.toSingle( onSend -> {
      delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), io.vertx.lang.rxjava3.Helper.convertHandler(onSend, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)elt)).collect(Collectors.toList()))));
    });
  }

  public static Redis newInstance(io.vertx.redis.client.Redis arg) {
    return arg != null ? new Redis(arg) : null;
  }

}
