/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.openapi.contract;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an OAuth Flows Object.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.OAuthFlows original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.OAuthFlows.class)
public class OAuthFlows implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuthFlows that = (OAuthFlows) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OAuthFlows> __TYPE_ARG = new TypeArg<>(    obj -> new OAuthFlows((io.vertx.openapi.contract.OAuthFlows) obj),
    OAuthFlows::getDelegate
  );

  private final io.vertx.openapi.contract.OAuthFlows delegate;
  
  public OAuthFlows(io.vertx.openapi.contract.OAuthFlows delegate) {
    this.delegate = delegate;
  }

  public OAuthFlows(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.OAuthFlows)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.OAuthFlows getDelegate() {
    return delegate;
  }

  /**
   * Configuration for the OAuth Implicit flow.
   * @return 
   */
  public io.vertx.rxjava3.openapi.contract.OAuthFlow getImplicit() { 
    io.vertx.rxjava3.openapi.contract.OAuthFlow ret = io.vertx.rxjava3.openapi.contract.OAuthFlow.newInstance((io.vertx.openapi.contract.OAuthFlow)delegate.getImplicit());
    return ret;
  }

  /**
   * Configuration for the OAuth Resource Owner Password flow
   * @return 
   */
  public io.vertx.rxjava3.openapi.contract.OAuthFlow getPassword() { 
    io.vertx.rxjava3.openapi.contract.OAuthFlow ret = io.vertx.rxjava3.openapi.contract.OAuthFlow.newInstance((io.vertx.openapi.contract.OAuthFlow)delegate.getPassword());
    return ret;
  }

  /**
   * Configuration for the OAuth Client Credentials flow. Previously called application in OpenAPI 2.0.
   * @return 
   */
  public io.vertx.rxjava3.openapi.contract.OAuthFlow getClientCredentials() { 
    io.vertx.rxjava3.openapi.contract.OAuthFlow ret = io.vertx.rxjava3.openapi.contract.OAuthFlow.newInstance((io.vertx.openapi.contract.OAuthFlow)delegate.getClientCredentials());
    return ret;
  }

  /**
   * Configuration for the OAuth Authorization Code flow. Previously called accessCode in OpenAPI 2.0.
   * @return 
   */
  public io.vertx.rxjava3.openapi.contract.OAuthFlow getAuthorizationCode() { 
    io.vertx.rxjava3.openapi.contract.OAuthFlow ret = io.vertx.rxjava3.openapi.contract.OAuthFlow.newInstance((io.vertx.openapi.contract.OAuthFlow)delegate.getAuthorizationCode());
    return ret;
  }

  public static OAuthFlows newInstance(io.vertx.openapi.contract.OAuthFlows arg) {
    return arg != null ? new OAuthFlows(arg) : null;
  }

}
