/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.validation;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This is the entry point of this module. Provides the parsing, validation and puts the parsed objects into . <br/>
 *
 * You can easily build a new validation handler using a , that you can create with . <br/>
 *
 * For more info read the doc. <br/>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.ValidationHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.ValidationHandler.class)
public class ValidationHandler implements RxDelegate, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValidationHandler that = (ValidationHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ValidationHandler> __TYPE_ARG = new TypeArg<>(    obj -> new ValidationHandler((io.vertx.ext.web.validation.ValidationHandler) obj),
    ValidationHandler::getDelegate
  );

  private final io.vertx.ext.web.validation.ValidationHandler delegate;
  
  public ValidationHandler(io.vertx.ext.web.validation.ValidationHandler delegate) {
    this.delegate = delegate;
  }

  public ValidationHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.ValidationHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.validation.ValidationHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * @param parser a SchemaParser
   * @return an instance of .
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder builder(io.vertx.rxjava3.json.schema.SchemaParser parser) { 
    io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder ret = io.vertx.rxjava3.ext.web.validation.builder.ValidationHandlerBuilder.newInstance((io.vertx.ext.web.validation.builder.ValidationHandlerBuilder)io.vertx.ext.web.validation.ValidationHandler.builder(parser.getDelegate()));
    return ret;
  }

  public static final java.lang.String REQUEST_CONTEXT_KEY = io.vertx.ext.web.validation.ValidationHandler.REQUEST_CONTEXT_KEY;
  public static ValidationHandler newInstance(io.vertx.ext.web.validation.ValidationHandler arg) {
    return arg != null ? new ValidationHandler(arg) : null;
  }

}
