/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.MultiMap;
import io.vertx.rxjava3.core.http.Cookie;
import io.vertx.rxjava3.core.http.HttpFrame;
import io.vertx.rxjava3.core.net.HostAndPort;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.ReadStreamSubscriber;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.core.http.HttpServerResponse.class)
public class HttpServerResponse
implements RxDelegate,
WriteStream<io.vertx.rxjava3.core.buffer.Buffer> {
    public static final TypeArg<HttpServerResponse> __TYPE_ARG = new TypeArg(obj -> new HttpServerResponse((io.vertx.core.http.HttpServerResponse)obj), HttpServerResponse::getDelegate);
    private final io.vertx.core.http.HttpServerResponse delegate;
    private WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> subscriber;
    private static final TypeArg<Cookie> TYPE_ARG_0 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private static final TypeArg<Cookie> TYPE_ARG_1 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private MultiMap cached_0;
    private MultiMap cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerResponse that = (HttpServerResponse)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
        this.delegate = delegate;
    }

    public HttpServerResponse(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerResponse)delegate;
    }

    public io.vertx.core.http.HttpServerResponse getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Completable write(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxWrite(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write((Object)data.getDelegate(), handler));
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpServerResponse drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public int getStatusCode() {
        int ret = this.delegate.getStatusCode();
        return ret;
    }

    public HttpServerResponse setStatusCode(int statusCode) {
        this.delegate.setStatusCode(statusCode);
        return this;
    }

    public String getStatusMessage() {
        String ret = this.delegate.getStatusMessage();
        return ret;
    }

    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.delegate.setStatusMessage(statusMessage);
        return this;
    }

    public HttpServerResponse setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpServerResponse putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    public HttpServerResponse putTrailer(String name, String value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpServerResponse endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        return this;
    }

    public Completable write(String chunk, String enc) {
        Completable ret = this.rxWrite(chunk, enc);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWrite(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write(chunk, enc, handler));
    }

    @Override
    public Completable write(String chunk) {
        Completable ret = this.rxWrite(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(String chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write(chunk, handler));
    }

    public HttpServerResponse writeContinue() {
        this.delegate.writeContinue();
        return this;
    }

    public Completable writeEarlyHints(MultiMap headers) {
        Completable ret = this.rxWriteEarlyHints(headers);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWriteEarlyHints(MultiMap headers) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.writeEarlyHints(headers.getDelegate(), handler));
    }

    @Override
    public Completable end(String chunk) {
        Completable ret = this.rxEnd(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(String chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(chunk, handler));
    }

    public Completable end(String chunk, String enc) {
        Completable ret = this.rxEnd(chunk, enc);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxEnd(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(chunk, enc, handler));
    }

    @Override
    public Completable end(io.vertx.rxjava3.core.buffer.Buffer chunk) {
        Completable ret = this.rxEnd(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(io.vertx.rxjava3.core.buffer.Buffer chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(chunk.getDelegate(), handler));
    }

    public Completable send() {
        Completable ret = this.rxSend();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.send(handler));
    }

    public Completable send(String body) {
        Completable ret = this.rxSend(body);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(String body) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.send(body, handler));
    }

    public Completable send(io.vertx.rxjava3.core.buffer.Buffer body) {
        Completable ret = this.rxSend(body);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(io.vertx.rxjava3.core.buffer.Buffer body) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.send(body.getDelegate(), handler));
    }

    public Completable send(Flowable<io.vertx.rxjava3.core.buffer.Buffer> body) {
        Completable ret = this.rxSend(body);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(Flowable<io.vertx.rxjava3.core.buffer.Buffer> body) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.send(ReadStreamSubscriber.asReadStream((Flowable)body, obj -> obj.getDelegate()).resume(), handler));
    }

    public Completable sendFile(String filename) {
        Completable ret = this.rxSendFile(filename);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.sendFile(filename, resultHandler));
    }

    public Completable sendFile(String filename, long offset) {
        Completable ret = this.rxSendFile(filename, offset);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename, long offset) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.sendFile(filename, offset, resultHandler));
    }

    public Completable sendFile(String filename, long offset, long length) {
        Completable ret = this.rxSendFile(filename, offset, length);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename, long offset, long length) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.sendFile(filename, offset, length, resultHandler));
    }

    @Deprecated
    public void close() {
        this.delegate.close();
    }

    public boolean ended() {
        boolean ret = this.delegate.ended();
        return ret;
    }

    public boolean closed() {
        boolean ret = this.delegate.closed();
        return ret;
    }

    public boolean headWritten() {
        boolean ret = this.delegate.headWritten();
        return ret;
    }

    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        this.delegate.headersEndHandler(handler);
        return this;
    }

    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        this.delegate.bodyEndHandler(handler);
        return this;
    }

    public long bytesWritten() {
        long ret = this.delegate.bytesWritten();
        return ret;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    @Deprecated
    public Single<HttpServerResponse> push(HttpMethod method, String host, String path) {
        Single ret = this.rxPush(method, host, path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    @Deprecated
    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.push(method, host, path, Helper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    public Single<HttpServerResponse> push(HttpMethod method, HostAndPort host, String path) {
        Single ret = this.rxPush(method, host, path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, HostAndPort host, String path) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.push(method, host.getDelegate(), path, Helper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    public Single<HttpServerResponse> push(HttpMethod method, String path, MultiMap headers) {
        Single ret = this.rxPush(method, path, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path, MultiMap headers) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.push(method, path, headers.getDelegate(), Helper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    public Single<HttpServerResponse> push(HttpMethod method, String path) {
        Single ret = this.rxPush(method, path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, String path) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.push(method, path, Helper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    @Deprecated
    public Single<HttpServerResponse> push(HttpMethod method, String host, String path, MultiMap headers) {
        Single ret = this.rxPush(method, host, path, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    @Deprecated
    public Single<HttpServerResponse> rxPush(HttpMethod method, String host, String path, MultiMap headers) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.push(method, host, path, headers.getDelegate(), Helper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    public Single<HttpServerResponse> push(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        Single ret = this.rxPush(method, authority, path, headers);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<HttpServerResponse> rxPush(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.push(method, authority.getDelegate(), path, headers.getDelegate(), Helper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public HttpServerResponse writeCustomFrame(int type, int flags, io.vertx.rxjava3.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public HttpServerResponse writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public HttpServerResponse addCookie(Cookie cookie) {
        this.delegate.addCookie(cookie.getDelegate());
        return this;
    }

    public Cookie removeCookie(String name) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name));
        return ret;
    }

    public Cookie removeCookie(String name, boolean invalidate) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, invalidate));
        return ret;
    }

    public Set<Cookie> removeCookies(String name) {
        Set<Cookie> ret = this.delegate.removeCookies(name).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Set<Cookie> removeCookies(String name, boolean invalidate) {
        Set<Cookie> ret = this.delegate.removeCookies(name, invalidate).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, domain, path));
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path, boolean invalidate) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, domain, path, invalidate));
        return ret;
    }

    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        this.delegate.putTrailer(name, values);
        return this;
    }

    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public static HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
        return arg != null ? new HttpServerResponse(arg) : null;
    }
}

