/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.auth;

import io.reactivex.rxjava3.core.Single;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.ext.auth.AuthProvider;
import io.vertx.rxjava3.ext.auth.authorization.Authorization;
import io.vertx.rxjava3.ext.auth.authorization.Authorizations;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.auth.User.class)
public class User {
    public static final TypeArg<User> __TYPE_ARG = new TypeArg(obj -> new User((io.vertx.ext.auth.User)obj), User::getDelegate);
    private final io.vertx.ext.auth.User delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User that = (User)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public User(io.vertx.ext.auth.User delegate) {
        this.delegate = delegate;
    }

    public User(Object delegate) {
        this.delegate = (io.vertx.ext.auth.User)delegate;
    }

    public io.vertx.ext.auth.User getDelegate() {
        return this.delegate;
    }

    public static User fromName(String username) {
        User ret = User.newInstance(io.vertx.ext.auth.User.fromName((String)username));
        return ret;
    }

    public static User fromToken(String token) {
        User ret = User.newInstance(io.vertx.ext.auth.User.fromToken((String)token));
        return ret;
    }

    public static User create(JsonObject principal) {
        User ret = User.newInstance(io.vertx.ext.auth.User.create((JsonObject)principal));
        return ret;
    }

    public static User create(JsonObject principal, JsonObject attributes) {
        User ret = User.newInstance(io.vertx.ext.auth.User.create((JsonObject)principal, (JsonObject)attributes));
        return ret;
    }

    public String subject() {
        String ret = this.delegate.subject();
        return ret;
    }

    public JsonObject attributes() {
        JsonObject ret = this.delegate.attributes();
        return ret;
    }

    public boolean expired() {
        boolean ret = this.delegate.expired();
        return ret;
    }

    public boolean expired(int leeway) {
        boolean ret = this.delegate.expired(leeway);
        return ret;
    }

    public <T> T get(String key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public <T> T getOrDefault(String key, T defaultValue) {
        Object ret = this.delegate.getOrDefault(key, defaultValue);
        return (T)ret;
    }

    public boolean containsKey(String key) {
        boolean ret = this.delegate.containsKey(key);
        return ret;
    }

    public Authorizations authorizations() {
        Authorizations ret = Authorizations.newInstance(this.delegate.authorizations());
        return ret;
    }

    @Deprecated
    public Single<Boolean> isAuthorized(Authorization authority) {
        Single ret = this.rxIsAuthorized(authority);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    @Deprecated
    public Single<Boolean> rxIsAuthorized(Authorization authority) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.isAuthorized(authority.getDelegate(), resultHandler));
    }

    @Deprecated
    public Single<Boolean> isAuthorized(String authority) {
        Single ret = this.rxIsAuthorized(authority);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    @Deprecated
    public Single<Boolean> rxIsAuthorized(String authority) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.isAuthorized(authority, resultHandler));
    }

    @Deprecated
    public User clearCache() {
        this.delegate.clearCache();
        return this;
    }

    public JsonObject principal() {
        JsonObject ret = this.delegate.principal();
        return ret;
    }

    @Deprecated
    public void setAuthProvider(AuthProvider authProvider) {
        this.delegate.setAuthProvider(authProvider.getDelegate());
    }

    public User merge(User other) {
        this.delegate.merge(other.getDelegate());
        return this;
    }

    public boolean hasAmr(String value) {
        boolean ret = this.delegate.hasAmr(value);
        return ret;
    }

    public static User newInstance(io.vertx.ext.auth.User arg) {
        return arg != null ? new User(arg) : null;
    }
}

