/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.web.sstore;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.ext.web.Session;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {
    public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg(obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore)obj), SessionStore::getDelegate);
    private final io.vertx.ext.web.sstore.SessionStore delegate;
    public static final int DEFAULT_SESSIONID_LENGTH = 16;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionStore that = (SessionStore)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
        this.delegate = delegate;
    }

    public SessionStore(Object delegate) {
        this.delegate = (io.vertx.ext.web.sstore.SessionStore)delegate;
    }

    public io.vertx.ext.web.sstore.SessionStore getDelegate() {
        return this.delegate;
    }

    public static SessionStore create(io.vertx.rxjava3.core.Vertx vertx) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static SessionStore create(io.vertx.rxjava3.core.Vertx vertx, JsonObject options) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate(), (JsonObject)options));
        return ret;
    }

    public SessionStore init(io.vertx.rxjava3.core.Vertx vertx, JsonObject options) {
        this.delegate.init(vertx.getDelegate(), options);
        return this;
    }

    public long retryTimeout() {
        long ret = this.delegate.retryTimeout();
        return ret;
    }

    public Session createSession(long timeout) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout));
        return ret;
    }

    public Session createSession(long timeout, int length) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout, length));
        return ret;
    }

    public Maybe<Session> get(String cookieValue) {
        Maybe ret = this.rxGet(cookieValue);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Maybe<Session> rxGet(String cookieValue) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.get(cookieValue, (Handler)new Handler<AsyncResult<io.vertx.ext.web.Session>>(){

            public void handle(AsyncResult<io.vertx.ext.web.Session> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)Session.newInstance((io.vertx.ext.web.Session)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Completable delete(String id) {
        Completable ret = this.rxDelete(id);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxDelete(String id) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.delete(id, resultHandler));
    }

    public Completable put(Session session) {
        Completable ret = this.rxPut(session);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxPut(Session session) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.put(session.getDelegate(), resultHandler));
    }

    public Completable clear() {
        Completable ret = this.rxClear();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxClear() {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.clear(resultHandler));
    }

    public Single<Integer> size() {
        Single ret = this.rxSize();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<Integer> rxSize() {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.size(resultHandler));
    }

    public void close() {
        this.delegate.close();
    }

    public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
        return arg != null ? new SessionStore(arg) : null;
    }
}

