/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.auth.oauth2;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.core.buffer.Buffer;
import io.vertx.rxjava3.ext.auth.User;
import io.vertx.rxjava3.ext.auth.oauth2.OAuth2Response;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken
extends User {
    public static final TypeArg<AccessToken> __TYPE_ARG = new TypeArg(obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken)obj), AccessToken::getDelegate);
    private final io.vertx.ext.auth.oauth2.AccessToken delegate;
    private JsonObject cached_0;
    private JsonObject cached_1;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
        super((io.vertx.ext.auth.User)delegate);
        this.delegate = delegate;
    }

    public AccessToken(Object delegate) {
        super((io.vertx.ext.auth.User)((io.vertx.ext.auth.oauth2.AccessToken)delegate));
        this.delegate = (io.vertx.ext.auth.oauth2.AccessToken)delegate;
    }

    public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
        return this.delegate;
    }

    public boolean isScopeGranted() {
        boolean ret = this.delegate.isScopeGranted();
        return ret;
    }

    public JsonObject accessToken() {
        JsonObject ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.accessToken();
        return ret;
    }

    public JsonObject idToken() {
        JsonObject ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.idToken();
        return ret;
    }

    public String opaqueAccessToken() {
        String ret = this.delegate.opaqueAccessToken();
        return ret;
    }

    public String opaqueRefreshToken() {
        String ret = this.delegate.opaqueRefreshToken();
        return ret;
    }

    public String opaqueIdToken() {
        String ret = this.delegate.opaqueIdToken();
        return ret;
    }

    public String tokenType() {
        String ret = this.delegate.tokenType();
        return ret;
    }

    public AccessToken setTrustJWT(boolean trust) {
        this.delegate.setTrustJWT(trust);
        return this;
    }

    public Completable refresh() {
        Completable ret = this.rxRefresh();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxRefresh() {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.refresh(callback));
    }

    public Completable revoke(String token_type) {
        Completable ret = this.rxRevoke(token_type);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxRevoke(String token_type) {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.revoke(token_type, callback));
    }

    public Completable logout() {
        Completable ret = this.rxLogout();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxLogout() {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.logout(callback));
    }

    public Completable introspect() {
        Completable ret = this.rxIntrospect();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxIntrospect() {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.introspect(callback));
    }

    public Completable introspect(String tokenType) {
        Completable ret = this.rxIntrospect(tokenType);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxIntrospect(String tokenType) {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.introspect(tokenType, callback));
    }

    public Single<JsonObject> userInfo() {
        Single ret = this.rxUserInfo();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<JsonObject> rxUserInfo() {
        return AsyncResultSingle.toSingle(callback -> this.delegate.userInfo(callback));
    }

    public Single<OAuth2Response> fetch(String resource) {
        Single ret = this.rxFetch(resource);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<OAuth2Response> rxFetch(String resource) {
        return AsyncResultSingle.toSingle(callback -> this.delegate.fetch(resource, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Single<OAuth2Response> fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload) {
        Single ret = this.rxFetch(method, resource, headers, payload);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<OAuth2Response> rxFetch(HttpMethod method, String resource, JsonObject headers, Buffer payload) {
        return AsyncResultSingle.toSingle(callback -> this.delegate.fetch(method, resource, headers, payload.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
        return arg != null ? new AccessToken(arg) : null;
    }
}

