/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQConfirmation;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.rxjava3.core.buffer.Buffer;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.rabbitmq.RabbitMQConsumer;
import io.vertx.rxjava3.rabbitmq.RabbitMQMessage;
import java.util.Map;

@RxGen(value=io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {
    public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg(obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient)obj), RabbitMQClient::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQClient that = (RabbitMQClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    public RabbitMQClient(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
    }

    public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
        return this.delegate;
    }

    public static RabbitMQClient create(io.vertx.rxjava3.core.Vertx vertx) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RabbitMQClient create(io.vertx.rxjava3.core.Vertx vertx, RabbitMQOptions config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate(), (RabbitMQOptions)config));
        return ret;
    }

    public Completable basicAck(long deliveryTag, boolean multiple) {
        Completable ret = this.rxBasicAck(deliveryTag, multiple);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxBasicAck(long deliveryTag, boolean multiple) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.basicAck(deliveryTag, multiple, resultHandler));
    }

    public Completable basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        Completable ret = this.rxBasicNack(deliveryTag, multiple, requeue);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.basicNack(deliveryTag, multiple, requeue, resultHandler));
    }

    public Single<RabbitMQMessage> basicGet(String queue, boolean autoAck) {
        Single ret = this.rxBasicGet(queue, autoAck);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<RabbitMQMessage> rxBasicGet(String queue, boolean autoAck) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.basicGet(queue, autoAck, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQMessage>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQMessage> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Single<RabbitMQConsumer> basicConsumer(String queue) {
        Single ret = this.rxBasicConsumer(queue);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.basicConsumer(queue, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Single<RabbitMQConsumer> basicConsumer(String queue, QueueOptions options) {
        Single ret = this.rxBasicConsumer(queue, options);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue, QueueOptions options) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.basicConsumer(queue, options, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Completable basicPublish(String exchange, String routingKey, Buffer body) {
        Completable ret = this.rxBasicPublish(exchange, routingKey, body);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxBasicPublish(String exchange, String routingKey, Buffer body) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.basicPublish(exchange, routingKey, body.getDelegate(), resultHandler));
    }

    public Single<ReadStream<RabbitMQConfirmation>> addConfirmListener(int maxQueueSize) {
        Single ret = this.rxAddConfirmListener(maxQueueSize);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<ReadStream<RabbitMQConfirmation>> rxAddConfirmListener(int maxQueueSize) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.addConfirmListener(maxQueueSize, (Handler)new Handler<AsyncResult<io.vertx.core.streams.ReadStream<RabbitMQConfirmation>>>(){

            public void handle(AsyncResult<io.vertx.core.streams.ReadStream<RabbitMQConfirmation>> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture(ReadStream.newInstance((io.vertx.core.streams.ReadStream)ar.result(), TypeArg.unknown())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Completable confirmSelect() {
        Completable ret = this.rxConfirmSelect();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxConfirmSelect() {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.confirmSelect(resultHandler));
    }

    public Completable waitForConfirms() {
        Completable ret = this.rxWaitForConfirms();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxWaitForConfirms() {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.waitForConfirms(resultHandler));
    }

    public Completable waitForConfirms(long timeout) {
        Completable ret = this.rxWaitForConfirms(timeout);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxWaitForConfirms(long timeout) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.waitForConfirms(timeout, resultHandler));
    }

    public Completable basicQos(int prefetchCount) {
        Completable ret = this.rxBasicQos(prefetchCount);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxBasicQos(int prefetchCount) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.basicQos(prefetchCount, resultHandler));
    }

    public Completable basicQos(int prefetchCount, boolean global) {
        Completable ret = this.rxBasicQos(prefetchCount, global);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxBasicQos(int prefetchCount, boolean global) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.basicQos(prefetchCount, global, resultHandler));
    }

    public Completable basicQos(int prefetchSize, int prefetchCount, boolean global) {
        Completable ret = this.rxBasicQos(prefetchSize, prefetchCount, global);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxBasicQos(int prefetchSize, int prefetchCount, boolean global) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.basicQos(prefetchSize, prefetchCount, global, resultHandler));
    }

    public Completable exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        Completable ret = this.rxExchangeDeclare(exchange, type, durable, autoDelete);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler));
    }

    public Completable exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        Completable ret = this.rxExchangeDeclare(exchange, type, durable, autoDelete, config);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler));
    }

    public Completable exchangeDelete(String exchange) {
        Completable ret = this.rxExchangeDelete(exchange);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxExchangeDelete(String exchange) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.exchangeDelete(exchange, resultHandler));
    }

    public Completable exchangeBind(String destination, String source, String routingKey) {
        Completable ret = this.rxExchangeBind(destination, source, routingKey);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxExchangeBind(String destination, String source, String routingKey) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.exchangeBind(destination, source, routingKey, resultHandler));
    }

    public Completable exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        Completable ret = this.rxExchangeBind(destination, source, routingKey, arguments);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxExchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.exchangeBind(destination, source, routingKey, arguments, resultHandler));
    }

    public Completable exchangeUnbind(String destination, String source, String routingKey) {
        Completable ret = this.rxExchangeUnbind(destination, source, routingKey);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxExchangeUnbind(String destination, String source, String routingKey) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.exchangeUnbind(destination, source, routingKey, resultHandler));
    }

    public Completable exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        Completable ret = this.rxExchangeUnbind(destination, source, routingKey, arguments);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxExchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.exchangeUnbind(destination, source, routingKey, arguments, resultHandler));
    }

    public Single<JsonObject> queueDeclareAuto() {
        Single ret = this.rxQueueDeclareAuto();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<JsonObject> rxQueueDeclareAuto() {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.queueDeclareAuto(resultHandler));
    }

    public Completable queueBind(String queue, String exchange, String routingKey) {
        Completable ret = this.rxQueueBind(queue, exchange, routingKey);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxQueueBind(String queue, String exchange, String routingKey) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.queueBind(queue, exchange, routingKey, resultHandler));
    }

    public Completable queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        Completable ret = this.rxQueueBind(queue, exchange, routingKey, arguments);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxQueueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.queueBind(queue, exchange, routingKey, arguments, resultHandler));
    }

    public Completable queueUnbind(String queue, String exchange, String routingKey) {
        Completable ret = this.rxQueueUnbind(queue, exchange, routingKey);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxQueueUnbind(String queue, String exchange, String routingKey) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.queueUnbind(queue, exchange, routingKey, resultHandler));
    }

    public Completable queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        Completable ret = this.rxQueueUnbind(queue, exchange, routingKey, arguments);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxQueueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.queueUnbind(queue, exchange, routingKey, arguments, resultHandler));
    }

    public Single<Long> messageCount(String queue) {
        Single ret = this.rxMessageCount(queue);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<Long> rxMessageCount(String queue) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.messageCount(queue, resultHandler));
    }

    public Completable start() {
        Completable ret = this.rxStart();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxStart() {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.start(resultHandler));
    }

    public Completable stop() {
        Completable ret = this.rxStop();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxStop() {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.stop(resultHandler));
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    public Completable basicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        Completable ret = this.rxBasicPublish(exchange, routingKey, properties, body);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxBasicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.basicPublish(exchange, routingKey, properties, body.getDelegate(), resultHandler));
    }

    public Completable basicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler) {
        Completable ret = this.rxBasicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxBasicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.basicPublishWithDeliveryTag(exchange, routingKey, properties, body.getDelegate(), deliveryTagHandler, resultHandler));
    }

    public Single<AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        Single ret = this.rxQueueDeclare(queue, durable, exclusive, autoDelete);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler));
    }

    public Single<AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        Single ret = this.rxQueueDeclare(queue, durable, exclusive, autoDelete, config);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler));
    }

    public Single<AMQP.Queue.DeleteOk> queueDelete(String queue) {
        Single ret = this.rxQueueDelete(queue);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDelete(String queue) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.queueDelete(queue, resultHandler));
    }

    public Single<AMQP.Queue.DeleteOk> queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        Single ret = this.rxQueueDeleteIf(queue, ifUnused, ifEmpty);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler));
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

