/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.impl;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AsyncResultCompletable
extends Completable {
    private final Consumer<Handler<AsyncResult<Void>>> subscriptionConsumer;

    public static Completable toCompletable(Consumer<Handler<AsyncResult<Void>>> subscriptionConsumer) {
        return RxJavaPlugins.onAssembly((Completable)new AsyncResultCompletable(subscriptionConsumer));
    }

    public static Completable toCompletable(Future<Void> subscriptionConsumer) {
        return RxJavaPlugins.onAssembly((Completable)new AsyncResultCompletable(arg_0 -> subscriptionConsumer.onComplete(arg_0)));
    }

    public static Completable toCompletable(Supplier<Future<Void>> subscriptionConsumer) {
        return RxJavaPlugins.onAssembly((Completable)new AsyncResultCompletable(h -> ((Future)subscriptionConsumer.get()).onComplete(h)));
    }

    private AsyncResultCompletable(Consumer<Handler<AsyncResult<Void>>> subscriptionConsumer) {
        this.subscriptionConsumer = subscriptionConsumer;
    }

    protected void subscribeActual(CompletableObserver observer) {
        block5: {
            final AtomicBoolean disposed = new AtomicBoolean();
            observer.onSubscribe(new Disposable(){

                public void dispose() {
                    disposed.set(true);
                }

                public boolean isDisposed() {
                    return disposed.get();
                }
            });
            if (!disposed.get()) {
                try {
                    this.subscriptionConsumer.accept((Handler<AsyncResult<Void>>)((Handler)ar -> {
                        if (!disposed.getAndSet(true)) {
                            if (ar.succeeded()) {
                                try {
                                    observer.onComplete();
                                }
                                catch (Throwable t) {
                                    Exceptions.throwIfFatal((Throwable)t);
                                    RxJavaPlugins.onError((Throwable)t);
                                }
                            } else {
                                try {
                                    observer.onError(ar.cause());
                                }
                                catch (Throwable t) {
                                    Exceptions.throwIfFatal((Throwable)t);
                                    RxJavaPlugins.onError((Throwable)t);
                                }
                            }
                        }
                    }));
                }
                catch (Exception e) {
                    if (disposed.getAndSet(true)) break block5;
                    try {
                        observer.onError((Throwable)e);
                    }
                    catch (Throwable t) {
                        Exceptions.throwIfFatal((Throwable)t);
                        RxJavaPlugins.onError((Throwable)t);
                    }
                }
            }
        }
    }
}

