/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.WorkerExecutorInternal;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ContextScheduler
extends Scheduler {
    private final Vertx vertx;
    private final boolean blocking;
    private final boolean ordered;
    private final Context context;
    private final WorkerExecutor workerExecutor;
    private static final Object DUMB = new JsonObject();

    public ContextScheduler(Context context, boolean blocking) {
        this(context, blocking, true);
    }

    public ContextScheduler(Context context, boolean blocking, boolean ordered) {
        this.vertx = context.owner();
        this.context = context;
        this.blocking = blocking;
        this.ordered = ordered;
        this.workerExecutor = null;
    }

    public ContextScheduler(Vertx vertx, boolean blocking) {
        this(vertx, blocking, true);
    }

    public ContextScheduler(Vertx vertx, boolean blocking, boolean ordered) {
        this.vertx = vertx;
        this.context = null;
        this.blocking = blocking;
        this.ordered = ordered;
        this.workerExecutor = null;
    }

    public ContextScheduler(WorkerExecutor workerExecutor) {
        this(workerExecutor, true);
    }

    public ContextScheduler(WorkerExecutor workerExecutor, boolean ordered) {
        Objects.requireNonNull(workerExecutor, "workerExecutor is null");
        this.vertx = ((WorkerExecutorInternal)workerExecutor).vertx();
        this.context = null;
        this.workerExecutor = workerExecutor;
        this.blocking = true;
        this.ordered = ordered;
    }

    public ContextWorker createWorker() {
        return new ContextWorker();
    }

    public class ContextWorker
    extends Scheduler.Worker {
        private final ConcurrentHashMap<TimedAction, Object> actions = new ConcurrentHashMap();
        private final AtomicBoolean cancelled = new AtomicBoolean();

        public int countActions() {
            return this.actions.size();
        }

        public Disposable schedule(Runnable action) {
            return this.schedule(action, 0L, TimeUnit.MILLISECONDS);
        }

        public Disposable schedule(Runnable action, long delayTime, TimeUnit unit) {
            action = RxJavaPlugins.onSchedule((Runnable)action);
            long delayMillis = unit.toMillis(delayTime);
            TimedAction timed = new TimedAction(action, 0L);
            this.actions.put(timed, DUMB);
            timed.schedule(delayMillis);
            return timed;
        }

        public Disposable schedulePeriodically(Runnable action, long initialDelay, long period, TimeUnit unit) {
            action = RxJavaPlugins.onSchedule((Runnable)action);
            long delayMillis = unit.toMillis(initialDelay);
            TimedAction timed = new TimedAction(action, unit.toMillis(period));
            this.actions.put(timed, DUMB);
            timed.schedule(delayMillis);
            return timed;
        }

        public void dispose() {
            if (this.cancelled.compareAndSet(false, true)) {
                ((ConcurrentHashMap.KeySetView)this.actions.keySet()).forEach(TimedAction::dispose);
            }
        }

        public boolean isDisposed() {
            return this.cancelled.get();
        }

        class TimedAction
        implements Disposable {
            private final Context context;
            private long id;
            private final Runnable action;
            private final long periodMillis;
            private boolean disposed;

            TimedAction(Runnable action, long periodMillis) {
                this.context = ContextScheduler.this.context != null ? ContextScheduler.this.context : ContextScheduler.this.vertx.getOrCreateContext();
                this.disposed = false;
                this.action = action;
                this.periodMillis = periodMillis;
            }

            private synchronized void schedule(long delayMillis) {
                if (delayMillis > 0L) {
                    this.id = ContextScheduler.this.vertx.setTimer(delayMillis, this::execute);
                } else {
                    this.id = -1L;
                    this.execute(null);
                }
            }

            private void execute(Object o) {
                if (ContextScheduler.this.workerExecutor != null) {
                    ContextScheduler.this.workerExecutor.executeBlocking(fut -> {
                        this.run(null);
                        fut.complete();
                    }, ContextScheduler.this.ordered, null);
                } else {
                    Context ctx;
                    Context context = ctx = this.context != null ? this.context : ContextScheduler.this.vertx.getOrCreateContext();
                    if (ContextScheduler.this.blocking) {
                        ctx.executeBlocking(fut -> {
                            this.run(null);
                            fut.complete();
                        }, ContextScheduler.this.ordered, null);
                    } else {
                        ctx.runOnContext(this::run);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void run(Object arg) {
                TimedAction timedAction = this;
                synchronized (timedAction) {
                    if (this.disposed) {
                        return;
                    }
                }
                this.action.run();
                timedAction = this;
                synchronized (timedAction) {
                    if (!this.disposed) {
                        if (this.periodMillis > 0L) {
                            this.schedule(this.periodMillis);
                        } else {
                            this.disposed = true;
                            ContextWorker.this.actions.remove(this);
                        }
                    }
                }
            }

            public synchronized void dispose() {
                if (!this.disposed) {
                    ContextWorker.this.actions.remove(this);
                    if (this.id > 0L) {
                        ContextScheduler.this.vertx.cancelTimer(this.id);
                    }
                    this.disposed = true;
                }
            }

            public synchronized boolean isDisposed() {
                return this.disposed;
            }
        }
    }
}

