/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.MaybeUnmarshaller;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public class MaybeHelper {
    public static <T> Maybe<T> toMaybe(Consumer<Handler<AsyncResult<T>>> handler) {
        return AsyncResultMaybe.toMaybe(handler);
    }

    public static <T> MaybeObserver<T> toObserver(final Handler<AsyncResult<T>> handler) {
        final AtomicBoolean completed = new AtomicBoolean();
        return new MaybeObserver<T>(){

            public void onSubscribe(@NonNull Disposable d) {
            }

            public void onComplete() {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture());
                }
            }

            public void onSuccess(@NonNull T item) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture(item));
                }
            }

            public void onError(Throwable error) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.failedFuture((Throwable)error));
                }
            }
        };
    }

    public static <T> Future<T> toFuture(Maybe<T> maybe) {
        Promise promise = Promise.promise();
        maybe.subscribe(arg_0 -> ((Promise)promise).complete(arg_0), arg_0 -> ((Promise)promise).fail(arg_0), () -> ((Promise)promise).complete());
        return promise.future();
    }

    public static <T, U> Future<U> toFuture(Maybe<T> maybe, Function<T, U> adapter) {
        return MaybeHelper.toFuture(maybe.map(adapter::apply));
    }

    public static <T> MaybeTransformer<Buffer, T> unmarshaller(Class<T> mappedType) {
        return new MaybeUnmarshaller(Function.identity(), mappedType);
    }

    public static <T> MaybeTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef) {
        return new MaybeUnmarshaller(Function.identity(), mappedTypeRef);
    }

    public static <T> MaybeTransformer<Buffer, T> unmarshaller(Class<T> mappedType, ObjectCodec mapper) {
        return new MaybeUnmarshaller(Function.identity(), mappedType, mapper);
    }

    public static <T> MaybeTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        return new MaybeUnmarshaller(Function.identity(), mappedTypeRef, mapper);
    }
}

