/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.redis.client;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.redis.client.RedisConnection;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicationConnectOptions;
import io.vertx.redis.client.RedisSentinelConnectOptions;
import io.vertx.redis.client.RedisStandaloneConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.List;
import java.util.function.Supplier;

@RxGen(value=io.vertx.redis.client.Redis.class)
public class Redis
implements RxDelegate {
    public static final TypeArg<Redis> __TYPE_ARG = new TypeArg(obj -> new Redis((io.vertx.redis.client.Redis)obj), Redis::getDelegate);
    private final io.vertx.redis.client.Redis delegate;
    private static final TypeArg<RedisConnection> TYPE_ARG_0 = new TypeArg(o1 -> RedisConnection.newInstance((io.vertx.redis.client.RedisConnection)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Redis that = (Redis)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Redis(io.vertx.redis.client.Redis delegate) {
        this.delegate = delegate;
    }

    public Redis(Object delegate) {
        this.delegate = (io.vertx.redis.client.Redis)delegate;
    }

    public io.vertx.redis.client.Redis getDelegate() {
        return this.delegate;
    }

    public static Redis createClient(io.vertx.reactivex.core.Vertx vertx) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static Redis createClient(io.vertx.reactivex.core.Vertx vertx, String connectionString) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (String)connectionString));
        return ret;
    }

    public static Redis createClient(io.vertx.reactivex.core.Vertx vertx, RedisOptions options) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (RedisOptions)options));
        return ret;
    }

    public static Redis createStandaloneClient(io.vertx.reactivex.core.Vertx vertx, RedisOptions options, final Supplier<Future<RedisStandaloneConnectOptions>> connectOptions) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createStandaloneClient((Vertx)vertx.getDelegate(), (RedisOptions)options, (Supplier)new Supplier<Future<RedisStandaloneConnectOptions>>(){

            @Override
            public Future<RedisStandaloneConnectOptions> get() {
                Future ret = (Future)connectOptions.get();
                return ret.map(val -> val);
            }
        }));
        return ret;
    }

    public static Redis createReplicationClient(io.vertx.reactivex.core.Vertx vertx, RedisOptions options, final Supplier<Future<RedisReplicationConnectOptions>> connectOptions) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createReplicationClient((Vertx)vertx.getDelegate(), (RedisOptions)options, (Supplier)new Supplier<Future<RedisReplicationConnectOptions>>(){

            @Override
            public Future<RedisReplicationConnectOptions> get() {
                Future ret = (Future)connectOptions.get();
                return ret.map(val -> val);
            }
        }));
        return ret;
    }

    public static Redis createSentinelClient(io.vertx.reactivex.core.Vertx vertx, RedisOptions options, final Supplier<Future<RedisSentinelConnectOptions>> connectOptions) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createSentinelClient((Vertx)vertx.getDelegate(), (RedisOptions)options, (Supplier)new Supplier<Future<RedisSentinelConnectOptions>>(){

            @Override
            public Future<RedisSentinelConnectOptions> get() {
                Future ret = (Future)connectOptions.get();
                return ret.map(val -> val);
            }
        }));
        return ret;
    }

    public static Redis createClusterClient(io.vertx.reactivex.core.Vertx vertx, RedisOptions options, final Supplier<Future<RedisClusterConnectOptions>> connectOptions) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClusterClient((Vertx)vertx.getDelegate(), (RedisOptions)options, (Supplier)new Supplier<Future<RedisClusterConnectOptions>>(){

            @Override
            public Future<RedisClusterConnectOptions> get() {
                Future ret = (Future)connectOptions.get();
                return ret.map(val -> val);
            }
        }));
        return ret;
    }

    public Future<RedisConnection> connect() {
        Future ret = this.delegate.connect().map(val -> RedisConnection.newInstance(val));
        return ret;
    }

    public Single<RedisConnection> rxConnect() {
        return AsyncResultSingle.toSingle($handler -> this.connect().onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<Response> send(Request command) {
        Future ret = this.delegate.send(command).map(val -> val);
        return ret;
    }

    public Maybe<Response> rxSend(Request command) {
        return AsyncResultMaybe.toMaybe($handler -> this.send(command).onComplete($handler));
    }

    public Future<List<Response>> batch(List<Request> commands) {
        Future ret = this.delegate.batch(commands).map(val -> val);
        return ret;
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return AsyncResultSingle.toSingle($handler -> this.batch(commands).onComplete($handler));
    }

    public static Redis newInstance(io.vertx.redis.client.Redis arg) {
        return arg != null ? new Redis(arg) : null;
    }
}

