/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQConfirmation;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.rabbitmq.RabbitMQConsumer;
import io.vertx.reactivex.rabbitmq.RabbitMQMessage;
import java.util.Map;

@RxGen(value=io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient
implements RxDelegate {
    public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg(obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient)obj), RabbitMQClient::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQClient delegate;
    private static final TypeArg<RabbitMQMessage> TYPE_ARG_0 = new TypeArg(o1 -> RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)o1), o1 -> o1.getDelegate());
    private static final TypeArg<RabbitMQConsumer> TYPE_ARG_1 = new TypeArg(o1 -> RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<RabbitMQConsumer> TYPE_ARG_2 = new TypeArg(o1 -> RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<io.vertx.reactivex.core.streams.ReadStream<RabbitMQConfirmation>> TYPE_ARG_3 = new TypeArg(o1 -> io.vertx.reactivex.core.streams.ReadStream.newInstance((ReadStream)o1, TypeArg.unknown()), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQClient that = (RabbitMQClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    public RabbitMQClient(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
    }

    public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
        return this.delegate;
    }

    public static RabbitMQClient create(io.vertx.reactivex.core.Vertx vertx) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RabbitMQClient create(io.vertx.reactivex.core.Vertx vertx, RabbitMQOptions config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate(), (RabbitMQOptions)config));
        return ret;
    }

    public Future<Void> basicAck(long deliveryTag, boolean multiple) {
        Future ret = this.delegate.basicAck(deliveryTag, multiple).map(val -> val);
        return ret;
    }

    public Completable rxBasicAck(long deliveryTag, boolean multiple) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicAck(deliveryTag, multiple).onComplete($handler));
    }

    public Future<Void> basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        Future ret = this.delegate.basicNack(deliveryTag, multiple, requeue).map(val -> val);
        return ret;
    }

    public Completable rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicNack(deliveryTag, multiple, requeue).onComplete($handler));
    }

    public Future<RabbitMQMessage> basicGet(String queue, boolean autoAck) {
        Future ret = this.delegate.basicGet(queue, autoAck).map(val -> RabbitMQMessage.newInstance(val));
        return ret;
    }

    public Single<RabbitMQMessage> rxBasicGet(String queue, boolean autoAck) {
        return AsyncResultSingle.toSingle($handler -> this.basicGet(queue, autoAck).onComplete($handler));
    }

    public Future<RabbitMQConsumer> basicConsumer(String queue) {
        Future ret = this.delegate.basicConsumer(queue).map(val -> RabbitMQConsumer.newInstance(val));
        return ret;
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue) {
        return AsyncResultSingle.toSingle($handler -> this.basicConsumer(queue).onComplete($handler));
    }

    public Future<RabbitMQConsumer> basicConsumer(String queue, QueueOptions options) {
        Future ret = this.delegate.basicConsumer(queue, options).map(val -> RabbitMQConsumer.newInstance(val));
        return ret;
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue, QueueOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.basicConsumer(queue, options).onComplete($handler));
    }

    public Future<Void> basicPublish(String exchange, String routingKey, Buffer body) {
        Future ret = this.delegate.basicPublish(exchange, routingKey, body).map(val -> val);
        return ret;
    }

    public Completable rxBasicPublish(String exchange, String routingKey, Buffer body) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicPublish(exchange, routingKey, body).onComplete($handler));
    }

    public Future<io.vertx.reactivex.core.streams.ReadStream<RabbitMQConfirmation>> addConfirmListener(int maxQueueSize) {
        Future ret = this.delegate.addConfirmListener(maxQueueSize).map(val -> io.vertx.reactivex.core.streams.ReadStream.newInstance(val, TypeArg.unknown()));
        return ret;
    }

    public Flowable<RabbitMQConfirmation> rxAddConfirmListener(int maxQueueSize) {
        return AsyncResultFlowable.toFlowable($handler -> this.addConfirmListener(maxQueueSize).map(stream_ -> stream_.getDelegate()).onComplete($handler));
    }

    public Future<Void> confirmSelect() {
        Future ret = this.delegate.confirmSelect().map(val -> val);
        return ret;
    }

    public Completable rxConfirmSelect() {
        return AsyncResultCompletable.toCompletable($handler -> this.confirmSelect().onComplete($handler));
    }

    public Future<Void> waitForConfirms() {
        Future ret = this.delegate.waitForConfirms().map(val -> val);
        return ret;
    }

    public Completable rxWaitForConfirms() {
        return AsyncResultCompletable.toCompletable($handler -> this.waitForConfirms().onComplete($handler));
    }

    public Future<Void> waitForConfirms(long timeout) {
        Future ret = this.delegate.waitForConfirms(timeout).map(val -> val);
        return ret;
    }

    public Completable rxWaitForConfirms(long timeout) {
        return AsyncResultCompletable.toCompletable($handler -> this.waitForConfirms(timeout).onComplete($handler));
    }

    public Future<Void> basicQos(int prefetchCount) {
        Future ret = this.delegate.basicQos(prefetchCount).map(val -> val);
        return ret;
    }

    public Completable rxBasicQos(int prefetchCount) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicQos(prefetchCount).onComplete($handler));
    }

    public Future<Void> basicQos(int prefetchCount, boolean global) {
        Future ret = this.delegate.basicQos(prefetchCount, global).map(val -> val);
        return ret;
    }

    public Completable rxBasicQos(int prefetchCount, boolean global) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicQos(prefetchCount, global).onComplete($handler));
    }

    public Future<Void> basicQos(int prefetchSize, int prefetchCount, boolean global) {
        Future ret = this.delegate.basicQos(prefetchSize, prefetchCount, global).map(val -> val);
        return ret;
    }

    public Completable rxBasicQos(int prefetchSize, int prefetchCount, boolean global) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicQos(prefetchSize, prefetchCount, global).onComplete($handler));
    }

    public Future<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        Future ret = this.delegate.exchangeDeclare(exchange, type, durable, autoDelete).map(val -> val);
        return ret;
    }

    public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeDeclare(exchange, type, durable, autoDelete).onComplete($handler));
    }

    public Future<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        Future ret = this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, config).map(val -> val);
        return ret;
    }

    public Completable rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeDeclare(exchange, type, durable, autoDelete, config).onComplete($handler));
    }

    public Future<Void> exchangeDelete(String exchange) {
        Future ret = this.delegate.exchangeDelete(exchange).map(val -> val);
        return ret;
    }

    public Completable rxExchangeDelete(String exchange) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeDelete(exchange).onComplete($handler));
    }

    public Future<Void> exchangeBind(String destination, String source, String routingKey) {
        Future ret = this.delegate.exchangeBind(destination, source, routingKey).map(val -> val);
        return ret;
    }

    public Completable rxExchangeBind(String destination, String source, String routingKey) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeBind(destination, source, routingKey).onComplete($handler));
    }

    public Future<Void> exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        Future ret = this.delegate.exchangeBind(destination, source, routingKey, arguments).map(val -> val);
        return ret;
    }

    public Completable rxExchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeBind(destination, source, routingKey, arguments).onComplete($handler));
    }

    public Future<Void> exchangeUnbind(String destination, String source, String routingKey) {
        Future ret = this.delegate.exchangeUnbind(destination, source, routingKey).map(val -> val);
        return ret;
    }

    public Completable rxExchangeUnbind(String destination, String source, String routingKey) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeUnbind(destination, source, routingKey).onComplete($handler));
    }

    public Future<Void> exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        Future ret = this.delegate.exchangeUnbind(destination, source, routingKey, arguments).map(val -> val);
        return ret;
    }

    public Completable rxExchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable($handler -> this.exchangeUnbind(destination, source, routingKey, arguments).onComplete($handler));
    }

    public Future<JsonObject> queueDeclareAuto() {
        Future ret = this.delegate.queueDeclareAuto().map(val -> val);
        return ret;
    }

    public Single<JsonObject> rxQueueDeclareAuto() {
        return AsyncResultSingle.toSingle($handler -> this.queueDeclareAuto().onComplete($handler));
    }

    public Future<Void> queueBind(String queue, String exchange, String routingKey) {
        Future ret = this.delegate.queueBind(queue, exchange, routingKey).map(val -> val);
        return ret;
    }

    public Completable rxQueueBind(String queue, String exchange, String routingKey) {
        return AsyncResultCompletable.toCompletable($handler -> this.queueBind(queue, exchange, routingKey).onComplete($handler));
    }

    public Future<Void> queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        Future ret = this.delegate.queueBind(queue, exchange, routingKey, arguments).map(val -> val);
        return ret;
    }

    public Completable rxQueueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable($handler -> this.queueBind(queue, exchange, routingKey, arguments).onComplete($handler));
    }

    public Future<Void> queueUnbind(String queue, String exchange, String routingKey) {
        Future ret = this.delegate.queueUnbind(queue, exchange, routingKey).map(val -> val);
        return ret;
    }

    public Completable rxQueueUnbind(String queue, String exchange, String routingKey) {
        return AsyncResultCompletable.toCompletable($handler -> this.queueUnbind(queue, exchange, routingKey).onComplete($handler));
    }

    public Future<Void> queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        Future ret = this.delegate.queueUnbind(queue, exchange, routingKey, arguments).map(val -> val);
        return ret;
    }

    public Completable rxQueueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return AsyncResultCompletable.toCompletable($handler -> this.queueUnbind(queue, exchange, routingKey, arguments).onComplete($handler));
    }

    public Future<Long> messageCount(String queue) {
        Future ret = this.delegate.messageCount(queue).map(val -> val);
        return ret;
    }

    public Single<Long> rxMessageCount(String queue) {
        return AsyncResultSingle.toSingle($handler -> this.messageCount(queue).onComplete($handler));
    }

    public Future<Void> start() {
        Future ret = this.delegate.start().map(val -> val);
        return ret;
    }

    public Completable rxStart() {
        return AsyncResultCompletable.toCompletable($handler -> this.start().onComplete($handler));
    }

    public Future<Void> stop() {
        Future ret = this.delegate.stop().map(val -> val);
        return ret;
    }

    public Completable rxStop() {
        return AsyncResultCompletable.toCompletable($handler -> this.stop().onComplete($handler));
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public Future<Void> restartConnect(int attempts) {
        Future ret = this.delegate.restartConnect(attempts).map(val -> val);
        return ret;
    }

    public Completable rxRestartConnect(int attempts) {
        return AsyncResultCompletable.toCompletable($handler -> this.restartConnect(attempts).onComplete($handler));
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    public Future<Void> basicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        Future ret = this.delegate.basicPublish(exchange, routingKey, properties, body).map(val -> val);
        return ret;
    }

    public Completable rxBasicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicPublish(exchange, routingKey, properties, body).onComplete($handler));
    }

    public Future<Void> basicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler) {
        Future ret = this.delegate.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler).map(val -> val);
        return ret;
    }

    public Completable rxBasicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler) {
        return AsyncResultCompletable.toCompletable($handler -> this.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler).onComplete($handler));
    }

    public Future<AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        Future ret = this.delegate.queueDeclare(queue, durable, exclusive, autoDelete).map(val -> val);
        return ret;
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return AsyncResultSingle.toSingle($handler -> this.queueDeclare(queue, durable, exclusive, autoDelete).onComplete($handler));
    }

    public Future<AMQP.Queue.DeclareOk> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        Future ret = this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, config).map(val -> val);
        return ret;
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return AsyncResultSingle.toSingle($handler -> this.queueDeclare(queue, durable, exclusive, autoDelete, config).onComplete($handler));
    }

    public Future<AMQP.Queue.DeleteOk> queueDelete(String queue) {
        Future ret = this.delegate.queueDelete(queue).map(val -> val);
        return ret;
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDelete(String queue) {
        return AsyncResultSingle.toSingle($handler -> this.queueDelete(queue).onComplete($handler));
    }

    public Future<AMQP.Queue.DeleteOk> queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        Future ret = this.delegate.queueDeleteIf(queue, ifUnused, ifEmpty).map(val -> val);
        return ret;
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        return AsyncResultSingle.toSingle($handler -> this.queueDeleteIf(queue, ifUnused, ifEmpty).onComplete($handler));
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

