/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.net.SocketAddress;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.HttpConnection.class)
public class HttpConnection
implements RxDelegate {
    public static final TypeArg<HttpConnection> __TYPE_ARG = new TypeArg(obj -> new HttpConnection((io.vertx.core.http.HttpConnection)obj), HttpConnection::getDelegate);
    private final io.vertx.core.http.HttpConnection delegate;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpConnection that = (HttpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
        this.delegate = delegate;
    }

    public HttpConnection(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpConnection)delegate;
    }

    public io.vertx.core.http.HttpConnection getDelegate() {
        return this.delegate;
    }

    public int getWindowSize() {
        int ret = this.delegate.getWindowSize();
        return ret;
    }

    public HttpConnection setWindowSize(int windowSize) {
        this.delegate.setWindowSize(windowSize);
        return this;
    }

    public HttpConnection goAway(long errorCode) {
        this.delegate.goAway(errorCode);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId) {
        this.delegate.goAway(errorCode, lastStreamId);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        this.delegate.goAway(errorCode, lastStreamId, debugData);
        return this;
    }

    public HttpConnection goAwayHandler(Handler<GoAway> handler) {
        this.delegate.goAwayHandler(handler);
        return this;
    }

    public HttpConnection shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    public Future<Void> shutdown() {
        Future ret = this.delegate.shutdown().map(val -> val);
        return ret;
    }

    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown().onComplete($handler));
    }

    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        Future ret = this.delegate.shutdown(timeout, unit).map(val -> val);
        return ret;
    }

    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(timeout, unit).onComplete($handler));
    }

    public HttpConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Http2Settings settings() {
        Http2Settings ret = this.delegate.settings();
        return ret;
    }

    public Future<Void> updateSettings(Http2Settings settings) {
        Future ret = this.delegate.updateSettings(settings).map(val -> val);
        return ret;
    }

    public Completable rxUpdateSettings(Http2Settings settings) {
        return AsyncResultCompletable.toCompletable($handler -> this.updateSettings(settings).onComplete($handler));
    }

    public Http2Settings remoteSettings() {
        Http2Settings ret = this.delegate.remoteSettings();
        return ret;
    }

    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        this.delegate.remoteSettingsHandler(handler);
        return this;
    }

    public Future<Buffer> ping(Buffer data) {
        Future ret = this.delegate.ping(data).map(val -> val);
        return ret;
    }

    public Single<Buffer> rxPing(Buffer data) {
        return AsyncResultSingle.toSingle($handler -> this.ping(data).onComplete($handler));
    }

    public HttpConnection pingHandler(Handler<Buffer> handler) {
        this.delegate.pingHandler(handler);
        return this;
    }

    public HttpConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.remoteAddress();
        return ret;
    }

    public SocketAddress remoteAddress(boolean real) {
        SocketAddress ret = this.delegate.remoteAddress(real);
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.localAddress();
        return ret;
    }

    public SocketAddress localAddress(boolean real) {
        SocketAddress ret = this.delegate.localAddress(real);
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
        return arg != null ? new HttpConnection(arg) : null;
    }
}

