/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.sstore;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.ext.web.Session;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {
    public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg(obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore)obj), SessionStore::getDelegate);
    private final io.vertx.ext.web.sstore.SessionStore delegate;
    private static final TypeArg<Session> TYPE_ARG_0 = new TypeArg(o1 -> Session.newInstance((io.vertx.ext.web.Session)o1), o1 -> o1.getDelegate());
    public static final int DEFAULT_SESSIONID_LENGTH = 16;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionStore that = (SessionStore)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
        this.delegate = delegate;
    }

    public SessionStore(Object delegate) {
        this.delegate = (io.vertx.ext.web.sstore.SessionStore)delegate;
    }

    public io.vertx.ext.web.sstore.SessionStore getDelegate() {
        return this.delegate;
    }

    public static SessionStore create(io.vertx.reactivex.core.Vertx vertx) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static SessionStore create(io.vertx.reactivex.core.Vertx vertx, JsonObject options) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate(), (JsonObject)options));
        return ret;
    }

    public SessionStore init(io.vertx.reactivex.core.Vertx vertx, JsonObject options) {
        this.delegate.init(vertx.getDelegate(), options);
        return this;
    }

    public long retryTimeout() {
        long ret = this.delegate.retryTimeout();
        return ret;
    }

    public Session createSession(long timeout) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout));
        return ret;
    }

    public Session createSession(long timeout, int length) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout, length));
        return ret;
    }

    public Future<Session> get(String cookieValue) {
        Future ret = this.delegate.get(cookieValue).map(val -> Session.newInstance(val));
        return ret;
    }

    public Maybe<Session> rxGet(String cookieValue) {
        return AsyncResultMaybe.toMaybe($handler -> this.get(cookieValue).onComplete($handler));
    }

    public Future<Void> delete(String id) {
        Future ret = this.delegate.delete(id).map(val -> val);
        return ret;
    }

    public Completable rxDelete(String id) {
        return AsyncResultCompletable.toCompletable($handler -> this.delete(id).onComplete($handler));
    }

    public Future<Void> put(Session session) {
        Future ret = this.delegate.put(session.getDelegate()).map(val -> val);
        return ret;
    }

    public Completable rxPut(Session session) {
        return AsyncResultCompletable.toCompletable($handler -> this.put(session).onComplete($handler));
    }

    public Future<Void> clear() {
        Future ret = this.delegate.clear().map(val -> val);
        return ret;
    }

    public Completable rxClear() {
        return AsyncResultCompletable.toCompletable($handler -> this.clear().onComplete($handler));
    }

    public Future<Integer> size() {
        Future ret = this.delegate.size().map(val -> val);
        return ret;
    }

    public Single<Integer> rxSize() {
        return AsyncResultSingle.toSingle($handler -> this.size().onComplete($handler));
    }

    public void close() {
        this.delegate.close();
    }

    public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
        return arg != null ? new SessionStore(arg) : null;
    }
}

