/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.amqp;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.amqp.AmqpConnection;
import io.vertx.reactivex.amqp.AmqpReceiver;
import io.vertx.reactivex.amqp.AmqpSender;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.amqp.AmqpClient.class)
public class AmqpClient
implements RxDelegate {
    public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg(obj -> new AmqpClient((io.vertx.amqp.AmqpClient)obj), AmqpClient::getDelegate);
    private final io.vertx.amqp.AmqpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpClient that = (AmqpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
        this.delegate = delegate;
    }

    public AmqpClient(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpClient)delegate;
    }

    public io.vertx.amqp.AmqpClient getDelegate() {
        return this.delegate;
    }

    public static AmqpClient create(AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((AmqpClientOptions)options));
        return ret;
    }

    public static AmqpClient create(io.vertx.reactivex.core.Vertx vertx, AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((Vertx)vertx.getDelegate(), (AmqpClientOptions)options));
        return ret;
    }

    public AmqpClient connect(Handler<AsyncResult<AmqpConnection>> connectionHandler) {
        this.delegate.connect(Helper.convertHandler(connectionHandler, ar -> ar.map(event -> AmqpConnection.newInstance(event))));
        return this;
    }

    public AmqpClient connect() {
        return this.connect((Handler<AsyncResult<AmqpConnection>>)((Handler)ar -> {}));
    }

    public Single<AmqpConnection> rxConnect() {
        return AsyncResultSingle.toSingle($handler -> this.connect((Handler<AsyncResult<AmqpConnection>>)$handler));
    }

    public void close(Handler<AsyncResult<Void>> closeHandler) {
        this.delegate.close(closeHandler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public AmqpClient createReceiver(String address, Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, Helper.convertHandler(completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event))));
        return this;
    }

    public AmqpClient createReceiver(String address) {
        return this.createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)((Handler)ar -> {}));
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address) {
        return AsyncResultSingle.toSingle($handler -> this.createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)$handler));
    }

    public AmqpClient createReceiver(String address, AmqpReceiverOptions receiverOptions, Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, receiverOptions, Helper.convertHandler(completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event))));
        return this;
    }

    public AmqpClient createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return this.createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)((Handler)ar -> {}));
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultSingle.toSingle($handler -> this.createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)$handler));
    }

    public AmqpClient createSender(String address, Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, Helper.convertHandler(completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event))));
        return this;
    }

    public AmqpClient createSender(String address) {
        return this.createSender(address, (Handler<AsyncResult<AmqpSender>>)((Handler)ar -> {}));
    }

    public Single<AmqpSender> rxCreateSender(String address) {
        return AsyncResultSingle.toSingle($handler -> this.createSender(address, (Handler<AsyncResult<AmqpSender>>)$handler));
    }

    public AmqpClient createSender(String address, AmqpSenderOptions options, Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, options, Helper.convertHandler(completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event))));
        return this;
    }

    public AmqpClient createSender(String address, AmqpSenderOptions options) {
        return this.createSender(address, options, (Handler<AsyncResult<AmqpSender>>)((Handler)ar -> {}));
    }

    public Single<AmqpSender> rxCreateSender(String address, AmqpSenderOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.createSender(address, options, (Handler<AsyncResult<AmqpSender>>)$handler));
    }

    public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
        return arg != null ? new AmqpClient(arg) : null;
    }
}

