/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.openapi;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface representing an <a href="https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.1.md#operationObject">Operation</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.openapi.Operation original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.openapi.Operation.class)
public class Operation implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Operation that = (Operation) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Operation> __TYPE_ARG = new TypeArg<>(    obj -> new Operation((io.vertx.ext.web.openapi.Operation) obj),
    Operation::getDelegate
  );

  private final io.vertx.ext.web.openapi.Operation delegate;
  
  public Operation(io.vertx.ext.web.openapi.Operation delegate) {
    this.delegate = delegate;
  }

  public Operation(Object delegate) {
    this.delegate = (io.vertx.ext.web.openapi.Operation)delegate;
  }

  @Override 
  public io.vertx.ext.web.openapi.Operation getDelegate() {
    return delegate;
  }

  /**
   * Mount an handler for this operation
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.ext.web.openapi.Operation handler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.handler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * Mount a failure handler for this operation
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.ext.web.openapi.Operation failureHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.failureHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * Route an incoming request to this operation to a Web API Service
   * @param address 
   * @return 
   */
  public io.vertx.reactivex.ext.web.openapi.Operation routeToEventBus(java.lang.String address) { 
    delegate.routeToEventBus(address);
    return this;
  }

  /**
   * Route an incoming request to this operation to a Web API Service
   * @param address 
   * @param options 
   * @return 
   */
  public io.vertx.reactivex.ext.web.openapi.Operation routeToEventBus(java.lang.String address, io.vertx.core.eventbus.DeliveryOptions options) { 
    delegate.routeToEventBus(address, options);
    return this;
  }

  /**
   * @return operationId of this operation
   */
  public java.lang.String getOperationId() { 
    java.lang.String ret = delegate.getOperationId();
    return ret;
  }

  /**
   * @return model of this operation
   */
  public io.vertx.core.json.JsonObject getOperationModel() { 
    io.vertx.core.json.JsonObject ret = delegate.getOperationModel();
    return ret;
  }

  /**
   * @return http method of this operation
   */
  public io.vertx.core.http.HttpMethod getHttpMethod() { 
    io.vertx.core.http.HttpMethod ret = delegate.getHttpMethod();
    return ret;
  }

  /**
   * @return path in OpenAPI style
   */
  public java.lang.String getOpenAPIPath() { 
    java.lang.String ret = delegate.getOpenAPIPath();
    return ret;
  }

  public static Operation newInstance(io.vertx.ext.web.openapi.Operation arg) {
    return arg != null ? new Operation(arg) : null;
  }

}
