/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql.ws;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A builder for {@link io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandler} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder.class)
public class GraphQLWSHandlerBuilder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GraphQLWSHandlerBuilder that = (GraphQLWSHandlerBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GraphQLWSHandlerBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new GraphQLWSHandlerBuilder((io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder) obj),
    GraphQLWSHandlerBuilder::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder delegate;
  
  public GraphQLWSHandlerBuilder(io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder delegate) {
    this.delegate = delegate;
  }

  public GraphQLWSHandlerBuilder(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder getDelegate() {
    return delegate;
  }

  /**
   * Change the {@link io.vertx.ext.web.handler.graphql.ws.GraphQLWSOptions} to use.
   * @param options 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder with(io.vertx.ext.web.handler.graphql.ws.GraphQLWSOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * Customize the connection init .
   * This handler will be called when the  message is received.
   * @param connectionInitHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder onConnectionInit(io.vertx.core.Handler<io.vertx.reactivex.ext.web.handler.graphql.ws.ConnectionInitEvent> connectionInitHandler) { 
    delegate.onConnectionInit(io.vertx.lang.reactivex.Helper.convertHandler(connectionInitHandler, event -> io.vertx.reactivex.ext.web.handler.graphql.ws.ConnectionInitEvent.newInstance((io.vertx.ext.web.handler.graphql.ws.ConnectionInitEvent)event)));
    return this;
  }

  /**
   * Set a callback to invoke before executing a GraphQL query.
   * @param beforeExecuteHandler the callback to invoke
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder beforeExecute(io.vertx.core.Handler<io.vertx.reactivex.ext.web.handler.graphql.ExecutionInputBuilderWithContext<io.vertx.reactivex.ext.web.handler.graphql.ws.Message>> beforeExecuteHandler) { 
    delegate.beforeExecute(io.vertx.lang.reactivex.Helper.convertHandler(beforeExecuteHandler, event -> io.vertx.reactivex.ext.web.handler.graphql.ExecutionInputBuilderWithContext.newInstance((io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext)event, new TypeArg<io.vertx.reactivex.ext.web.handler.graphql.ws.Message>(o0 -> io.vertx.reactivex.ext.web.handler.graphql.ws.Message.newInstance((io.vertx.ext.web.handler.graphql.ws.Message)o0), o0 -> o0.getDelegate()))));
    return this;
  }

  /**
   * Customize the message .
   * This handler will be called for each {@link io.vertx.reactivex.ext.web.handler.graphql.ws.Message} received.
   * @param messageHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder onMessage(io.vertx.core.Handler<io.vertx.reactivex.ext.web.handler.graphql.ws.Message> messageHandler) { 
    delegate.onMessage(io.vertx.lang.reactivex.Helper.convertHandler(messageHandler, event -> io.vertx.reactivex.ext.web.handler.graphql.ws.Message.newInstance((io.vertx.ext.web.handler.graphql.ws.Message)event)));
    return this;
  }

  /**
   * Customize the end .
   * This handler will be called at the end of each websocket connection.
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder onSocketEnd(io.vertx.core.Handler<io.vertx.reactivex.core.http.ServerWebSocket> endHandler) { 
    delegate.onSocketEnd(io.vertx.lang.reactivex.Helper.convertHandler(endHandler, event -> io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event)));
    return this;
  }

  /**
   * @return a new instance of {@link io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandler}
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandler build() { 
    io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandler ret = io.vertx.reactivex.ext.web.handler.graphql.ws.GraphQLWSHandler.newInstance((io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandler)delegate.build());
    return ret;
  }

  public static GraphQLWSHandlerBuilder newInstance(io.vertx.ext.web.handler.graphql.ws.GraphQLWSHandlerBuilder arg) {
    return arg != null ? new GraphQLWSHandlerBuilder(arg) : null;
  }

}
