/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.otp.totp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An extension of AuthProvider which uses the one time passwords based on time to perform authentication.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.otp.totp.TotpAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.otp.totp.TotpAuth.class)
public class TotpAuth extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TotpAuth that = (TotpAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TotpAuth> __TYPE_ARG = new TypeArg<>(    obj -> new TotpAuth((io.vertx.ext.auth.otp.totp.TotpAuth) obj),
    TotpAuth::getDelegate
  );

  private final io.vertx.ext.auth.otp.totp.TotpAuth delegate;
  
  public TotpAuth(io.vertx.ext.auth.otp.totp.TotpAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public TotpAuth(Object delegate) {
    super((io.vertx.ext.auth.otp.totp.TotpAuth)delegate);
    this.delegate = (io.vertx.ext.auth.otp.totp.TotpAuth)delegate;
  }

  @Override 
  public io.vertx.ext.auth.otp.totp.TotpAuth getDelegate() {
    return delegate;
  }


  /**
   * Provide a  that can fetch s from a backend given an <code>identifier</code>
   * argument.
   *
   * The function signature is as follows:
   *
   * <code>(id) -> Future<Authenticator></code>
   *
   * <ul>
   *   <li><code>id</code> the identifier to lookup.</li>
   *   <li> async result with a authenticator.</li>
   * </ul>
   * @param fetcher fetcher function.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.otp.totp.TotpAuth authenticatorFetcher(java.util.function.Function<java.lang.String,io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator>> fetcher) { 
    delegate.authenticatorFetcher(new Function<java.lang.String,io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator>>() {
      public io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator> apply(java.lang.String arg) {
        io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator> ret = fetcher.apply(arg);
        return ret.map(val -> val);
      }
    });
    return this;
  }

  /**
   * Provide a  that can fetch s from a backend given an <code>identifier</code>
   * argument.
   *
   * The function signature is as follows:
   *
   * <code>(id) -> Future<Authenticator></code>
   *
   * <ul>
   *   <li><code>id</code> the identifier to lookup.</li>
   *   <li> async result with a authenticator.</li>
   * </ul>
   * @param fetcher fetcher function.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.otp.totp.TotpAuth authenticatorFetcher(io.reactivex.functions.Function<java.lang.String,io.reactivex.Single<io.vertx.ext.auth.otp.Authenticator>> fetcher) { 
    delegate.authenticatorFetcher(new Function<java.lang.String,io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator>>() {
      public io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator> apply(java.lang.String arg) {
        io.reactivex.Single<io.vertx.ext.auth.otp.Authenticator> ret;
        try {
          ret = fetcher.apply(arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj);
      }
    });
    return this;
  }

  /**
   * Provide a  that can update or insert a .
   * The function <strong>should</strong> store a given authenticator to a persistence storage.
   *
   * When an authenticator is already present, this method <strong>must</strong> at least update
   * , and is not required to perform any other update.
   *
   * For new authenticators, the whole object data <strong>must</strong> be persisted.
   *
   * The function signature is as follows:
   *
   * <code>(Authenticator) -> Future<Void></code>
   *
   * <ul>
   *   <li> the authenticator data to update.</li>
   *   <li>async result of the operation.</li>
   * </ul>
   * @param updater updater function.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.otp.totp.TotpAuth authenticatorUpdater(java.util.function.Function<io.vertx.ext.auth.otp.Authenticator,io.vertx.core.Future<java.lang.Void>> updater) { 
    delegate.authenticatorUpdater(new Function<io.vertx.ext.auth.otp.Authenticator,io.vertx.core.Future<java.lang.Void>>() {
      public io.vertx.core.Future<java.lang.Void> apply(io.vertx.ext.auth.otp.Authenticator arg) {
        io.vertx.core.Future<java.lang.Void> ret = updater.apply(arg);
        return ret.map(val -> val);
      }
    });
    return this;
  }

  /**
   * Provide a  that can update or insert a .
   * The function <strong>should</strong> store a given authenticator to a persistence storage.
   *
   * When an authenticator is already present, this method <strong>must</strong> at least update
   * , and is not required to perform any other update.
   *
   * For new authenticators, the whole object data <strong>must</strong> be persisted.
   *
   * The function signature is as follows:
   *
   * <code>(Authenticator) -> Future<Void></code>
   *
   * <ul>
   *   <li> the authenticator data to update.</li>
   *   <li>async result of the operation.</li>
   * </ul>
   * @param updater updater function.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.otp.totp.TotpAuth authenticatorUpdater(io.reactivex.functions.Function<io.vertx.ext.auth.otp.Authenticator,io.reactivex.Completable> updater) { 
    delegate.authenticatorUpdater(new Function<io.vertx.ext.auth.otp.Authenticator,io.vertx.core.Future<Void>>() {
      public io.vertx.core.Future<Void> apply(io.vertx.ext.auth.otp.Authenticator arg) {
        io.reactivex.Completable ret;
        try {
          ret = updater.apply(arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.CompletableHelper.toFuture(ret);
      }
    });
    return this;
  }

  /**
   * Creating authenticator from user id and key.
   * @param id id user.
   * @param otpKey key of user used for auth.
   * @return  an object containing all the necessary information to authenticate a user.
   */
  public io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator> createAuthenticator(java.lang.String id, io.vertx.ext.auth.otp.OtpKey otpKey) { 
    io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator> ret = delegate.createAuthenticator(id, otpKey).map(val -> val);
    return ret;
  }

  /**
   * Creating URI for register in key in user device.
   * @param otpKey user key.
   * @param issuer issuer of key.
   * @param user display name of user account.
   * @param label the label to identify which account a key is associated with.
   * @return uri containing the key.
   */
  public java.lang.String generateUri(io.vertx.ext.auth.otp.OtpKey otpKey, java.lang.String issuer, java.lang.String user, java.lang.String label) { 
    java.lang.String ret = delegate.generateUri(otpKey, issuer, user, label);
    return ret;
  }

  /**
   * Creating URI for register in key in user device.
   * @param otpKey user key.
   * @param issuer issuer of key.
   * @param user display name of user account.
   * @return uri containing the key.
   */
  public java.lang.String generateUri(io.vertx.ext.auth.otp.OtpKey otpKey, java.lang.String issuer, java.lang.String user) { 
    java.lang.String ret = delegate.generateUri(otpKey, issuer, user);
    return ret;
  }

  /**
   * Creating URI for register in key in user device.
   * @param otpKey user key.
   * @param label the label to identify which account a key is associated with.
   * @return uri containing the key.
   */
  public java.lang.String generateUri(io.vertx.ext.auth.otp.OtpKey otpKey, java.lang.String label) { 
    java.lang.String ret = delegate.generateUri(otpKey, label);
    return ret;
  }

  /**
   * Creates an instance of TotpAuth.
   * @return the created instance of {@link io.vertx.reactivex.ext.auth.otp.totp.TotpAuth}.
   */
  public static io.vertx.reactivex.ext.auth.otp.totp.TotpAuth create() { 
    io.vertx.reactivex.ext.auth.otp.totp.TotpAuth ret = io.vertx.reactivex.ext.auth.otp.totp.TotpAuth.newInstance((io.vertx.ext.auth.otp.totp.TotpAuth)io.vertx.ext.auth.otp.totp.TotpAuth.create());
    return ret;
  }

  /**
   * Creates an instance of TotpAuth.
   * @param totpAuthOptions the config.
   * @return the created instance of {@link io.vertx.reactivex.ext.auth.otp.totp.TotpAuth}.
   */
  public static io.vertx.reactivex.ext.auth.otp.totp.TotpAuth create(io.vertx.ext.auth.otp.totp.TotpAuthOptions totpAuthOptions) { 
    io.vertx.reactivex.ext.auth.otp.totp.TotpAuth ret = io.vertx.reactivex.ext.auth.otp.totp.TotpAuth.newInstance((io.vertx.ext.auth.otp.totp.TotpAuth)io.vertx.ext.auth.otp.totp.TotpAuth.create(totpAuthOptions));
    return ret;
  }

  public static TotpAuth newInstance(io.vertx.ext.auth.otp.totp.TotpAuth arg) {
    return arg != null ? new TotpAuth(arg) : null;
  }

}
