/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.json.schema;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.json.schema.JsonFormatValidator.class)
public class JsonFormatValidator implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonFormatValidator that = (JsonFormatValidator) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JsonFormatValidator> __TYPE_ARG = new TypeArg<>(    obj -> new JsonFormatValidator((io.vertx.json.schema.JsonFormatValidator) obj),
    JsonFormatValidator::getDelegate
  );

  private final io.vertx.json.schema.JsonFormatValidator delegate;
  
  public JsonFormatValidator(io.vertx.json.schema.JsonFormatValidator delegate) {
    this.delegate = delegate;
  }

  public JsonFormatValidator(Object delegate) {
    this.delegate = (io.vertx.json.schema.JsonFormatValidator)delegate;
  }

  @Override 
  public io.vertx.json.schema.JsonFormatValidator getDelegate() {
    return delegate;
  }

  /**
   * @param instanceType The type of the related instance
   * @param format The format specified in the schema for the current object instance.
   * @param instance The current object instance that is currently being validated.
   * @return Any string if there are any format validation errors, null if there are no validation errors.
   */
  public java.lang.String validateFormat(java.lang.String instanceType, java.lang.String format, java.lang.Object instance) { 
    java.lang.String ret = delegate.validateFormat(instanceType, format, instance);
    return ret;
  }

  /**
   * The default validator which performs a NOOP.
   */
  public static final io.vertx.reactivex.json.schema.JsonFormatValidator DEFAULT_VALIDATOR = io.vertx.reactivex.json.schema.JsonFormatValidator.newInstance((io.vertx.json.schema.JsonFormatValidator)io.vertx.json.schema.JsonFormatValidator.DEFAULT_VALIDATOR);
  public static JsonFormatValidator newInstance(io.vertx.json.schema.JsonFormatValidator arg) {
    return arg != null ? new JsonFormatValidator(arg) : null;
  }

}
