/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A parsed language header.
 * Delivers a more direct access to the individual elements of the header it represents
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.LanguageHeader original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.LanguageHeader.class)
public class LanguageHeader implements RxDelegate, io.vertx.reactivex.ext.web.ParsedHeaderValue {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LanguageHeader that = (LanguageHeader) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<LanguageHeader> __TYPE_ARG = new TypeArg<>(    obj -> new LanguageHeader((io.vertx.ext.web.LanguageHeader) obj),
    LanguageHeader::getDelegate
  );

  private final io.vertx.ext.web.LanguageHeader delegate;
  
  public LanguageHeader(io.vertx.ext.web.LanguageHeader delegate) {
    this.delegate = delegate;
  }

  public LanguageHeader(Object delegate) {
    this.delegate = (io.vertx.ext.web.LanguageHeader)delegate;
  }

  @Override 
  public io.vertx.ext.web.LanguageHeader getDelegate() {
    return delegate;
  }


  /**
   * Contains the raw value that was received from the user agent
   * @return 
   */
  public java.lang.String rawValue() { 
    java.lang.String ret = delegate.rawValue();
    return ret;
  }

  /**
   * Holds the unparsed value of the header.<br>
   * For the most part, this is the content before the semi-colon (";")
   * @return 
   */
  public java.lang.String value() { 
    java.lang.String ret = delegate.value();
    return ret;
  }

  /**
   * Holds the weight specified in the "q" parameter of the header.<br>
   * If the parameter is not specified, 1.0 is assumed according to
   * <a href="https://tools.ietf.org/html/rfc7231#section-5.3.1">rfc7231</a>
   * @return 
   */
  public float weight() { 
    float ret = delegate.weight();
    return ret;
  }

  /**
   * The value of the parameter specified by this key. Each is one of 3 things:
   * <ol>
   * <li>null &lt;- That key was not specified</li>
   * <li>ParsedHeaderValue.EMPTY (tested using ==) &lt;- The value was not specified</li>
   * <li>[Other] <- The value of the parameter</li>
   * </ol>
   * <b>Note:</b> The <code>q</code> parameter is never present.
   * @param key 
   * @return 
   */
  public java.lang.String parameter(java.lang.String key) { 
    java.lang.String ret = delegate.parameter(key);
    return ret;
  }

  /**
   * The parameters specified in this header value.
   * <b>Note:</b> The <code>q</code> parameter is never present.
   * @return Unmodifiable Map of parameters of this header value
   */
  public java.util.Map<java.lang.String,java.lang.String> parameters() { 
    java.util.Map<java.lang.String,java.lang.String> ret = delegate.parameters();
    return ret;
  }

  /**
   * Is this an allowed operation as specified by the corresponding header?
   * @return 
   */
  public boolean isPermitted() { 
    boolean ret = delegate.isPermitted();
    return ret;
  }

  /**
   * Test if this header is matched by matchTry header
   * @param matchTry The header to be matched from
   * @return true if this header represents a subset of matchTry, otherwise, false
   */
  public boolean isMatchedBy(io.vertx.reactivex.ext.web.ParsedHeaderValue matchTry) { 
    boolean ret = delegate.isMatchedBy(matchTry.getDelegate());
    return ret;
  }

  /**
   * An integer that represents the absolute order position of this header
   * @return 
   */
  public int weightedOrder() { 
    int ret = delegate.weightedOrder();
    return ret;
  }

  /**
   * The tag of the language as specified by
   * <a href="https://tools.ietf.org/html/rfc7231#section-3.1.3.1">rfc7231#section-3.1.3.1</a>.<br>
   * Equivalent to 
   * @return The language tag
   */
  public java.lang.String tag() { 
    java.lang.String ret = delegate.tag();
    return ret;
  }

  /**
   * The subtag of the language as specified by
   * <a href="https://tools.ietf.org/html/rfc7231#section-3.1.3.1">rfc7231#section-3.1.3.1</a>.<br>
   * Equivalent to 
   * @return The language subtag
   */
  public java.lang.String subtag() { 
    java.lang.String ret = delegate.subtag();
    return ret;
  }

  /**
   * A subtag of this language header.<br>
   * + info: <a href="https://tools.ietf.org/html/rfc7231#section-3.1.3.1">rfc7231#section-3.1.3.1</a>
   * @param level 
   * @return The language subtag at specified position
   */
  public java.lang.String subtag(int level) { 
    java.lang.String ret = delegate.subtag(level);
    return ret;
  }

  /**
   * @return the number of subtags this value has
   */
  public int subtagCount() { 
    int ret = delegate.subtagCount();
    return ret;
  }

  /**
   * <quote>If no "q" parameter is present, the default weight is 1.</quote>
   */
  public static final float DEFAULT_WEIGHT = io.vertx.ext.web.LanguageHeader.DEFAULT_WEIGHT;
  public static LanguageHeader newInstance(io.vertx.ext.web.LanguageHeader arg) {
    return arg != null ? new LanguageHeader(arg) : null;
  }

}
