/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.net.SSLOptions;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.core.http.ServerWebSocket;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.http.HttpServer.class)
public class HttpServer
implements Measured {
    public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg(obj -> new HttpServer((io.vertx.core.http.HttpServer)obj), HttpServer::getDelegate);
    private final io.vertx.core.http.HttpServer delegate;
    private static final TypeArg<HttpServerRequest> TYPE_ARG_0 = new TypeArg(o1 -> HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());
    private static final TypeArg<ServerWebSocket> TYPE_ARG_1 = new TypeArg(o1 -> ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
    private ReadStream<HttpServerRequest> cached_0;
    private ReadStream<ServerWebSocket> cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServer that = (HttpServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    public HttpServer(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServer)delegate;
    }

    public io.vertx.core.http.HttpServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @Deprecated
    public ReadStream<HttpServerRequest> requestStream() {
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        ReadStream<HttpServerRequest> ret = ReadStream.newInstance(this.delegate.requestStream(), TYPE_ARG_0);
        this.cached_0 = ret;
        return ret;
    }

    public HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        this.delegate.requestHandler((Handler)new DelegatingHandler(handler, event -> HttpServerRequest.newInstance(event)));
        return this;
    }

    public HttpServer invalidRequestHandler(Handler<HttpServerRequest> handler) {
        HttpServer ret = HttpServer.newInstance(this.delegate.invalidRequestHandler((Handler)new DelegatingHandler(handler, event -> HttpServerRequest.newInstance(event))));
        return ret;
    }

    public HttpServer connectionHandler(Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new DelegatingHandler(handler, event -> HttpConnection.newInstance(event)));
        return this;
    }

    public HttpServer exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Deprecated
    public ReadStream<ServerWebSocket> webSocketStream() {
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        ReadStream<ServerWebSocket> ret = ReadStream.newInstance(this.delegate.webSocketStream(), TYPE_ARG_1);
        this.cached_1 = ret;
        return ret;
    }

    public HttpServer webSocketHandler(Handler<ServerWebSocket> handler) {
        this.delegate.webSocketHandler((Handler)new DelegatingHandler(handler, event -> ServerWebSocket.newInstance(event)));
        return this;
    }

    public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, handler);
    }

    public void updateSSLOptions(SSLOptions options) {
        this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)$handler));
    }

    public void updateSSLOptions(SSLOptions options, boolean force, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, force, handler);
    }

    public void updateSSLOptions(SSLOptions options, boolean force) {
        this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)$handler));
    }

    public HttpServer listen(int port, String host, Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, host, (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> HttpServer.newInstance(event))));
        return this;
    }

    public HttpServer listen(int port, String host) {
        return this.listen(port, host, (Handler<AsyncResult<HttpServer>>)((Handler)ar -> {}));
    }

    public Single<HttpServer> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.listen(port, host, (Handler<AsyncResult<HttpServer>>)$handler));
    }

    public HttpServer listen(SocketAddress address, Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(address.getDelegate(), (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> HttpServer.newInstance(event))));
        return this;
    }

    public HttpServer listen(SocketAddress address) {
        return this.listen(address, (Handler<AsyncResult<HttpServer>>)((Handler)ar -> {}));
    }

    public Single<HttpServer> rxListen(SocketAddress address) {
        return AsyncResultSingle.toSingle($handler -> this.listen(address, (Handler<AsyncResult<HttpServer>>)$handler));
    }

    public HttpServer listen(int port, Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> HttpServer.newInstance(event))));
        return this;
    }

    public HttpServer listen(int port) {
        return this.listen(port, (Handler<AsyncResult<HttpServer>>)((Handler)ar -> {}));
    }

    public Single<HttpServer> rxListen(int port) {
        return AsyncResultSingle.toSingle($handler -> this.listen(port, (Handler<AsyncResult<HttpServer>>)$handler));
    }

    public HttpServer listen(Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen((Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> HttpServer.newInstance(event))));
        return this;
    }

    public HttpServer listen() {
        return this.listen((Handler<AsyncResult<HttpServer>>)((Handler)ar -> {}));
    }

    public Single<HttpServer> rxListen() {
        return AsyncResultSingle.toSingle($handler -> this.listen((Handler<AsyncResult<HttpServer>>)$handler));
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

