/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.servicediscovery.types;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *  for event bus services (service proxies).
 * Consumers receive a service proxy to use the service.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.EventBusService original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.types.EventBusService.class)
public class EventBusService implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBusService that = (EventBusService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<EventBusService> __TYPE_ARG = new TypeArg<>(    obj -> new EventBusService((io.vertx.servicediscovery.types.EventBusService) obj),
    EventBusService::getDelegate
  );

  private final io.vertx.servicediscovery.types.EventBusService delegate;
  
  public EventBusService(io.vertx.servicediscovery.types.EventBusService delegate) {
    this.delegate = delegate;
  }

  public EventBusService(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.EventBusService)delegate;
  }

  @Override 
  public io.vertx.servicediscovery.types.EventBusService getDelegate() {
    return delegate;
  }

  /**
   * Sugar method to creates a record for this type.
   * <p>
   * The java interface is added to the metadata in the `service.interface` key.
   * @param name the name of the service.
   * @param address the event bus address on which the service available
   * @param itf the Java interface (name)
   * @param metadata the metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(java.lang.String name, java.lang.String address, java.lang.String itf, io.vertx.core.json.JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.EventBusService.createRecord(name, address, itf, metadata);
    return ret;
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * @param discovery the service discovery
   * @param filter the filter
   * @param clientClass the client class
   * @param resultHandler the result handler
   * @return <code>null</code> - do not use
   */
  public static <T> T getServiceProxy(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, java.lang.Class<T> clientClass, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> resultHandler) { 
    T ret = (T)TypeArg.of(clientClass).wrap(io.vertx.servicediscovery.types.EventBusService.getServiceProxy(discovery.getDelegate(), filter, io.vertx.lang.reactivex.Helper.unwrap(clientClass), io.vertx.lang.reactivex.Helper.convertHandler(resultHandler, ar -> ar.map(event -> (T)TypeArg.of(clientClass).wrap(event)))));
    return ret;
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * @param discovery the service discovery
   * @param filter the filter
   * @param clientClass the client class
   * @param conf the configuration for message delivery
   * @param resultHandler the result handler
   * @return <code>null</code> - do not use
   */
  public static <T> T getServiceProxy(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, java.lang.Class<T> clientClass, io.vertx.core.json.JsonObject conf, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> resultHandler) { 
    T ret = (T)TypeArg.of(clientClass).wrap(io.vertx.servicediscovery.types.EventBusService.getServiceProxy(discovery.getDelegate(), filter, io.vertx.lang.reactivex.Helper.unwrap(clientClass), conf, io.vertx.lang.reactivex.Helper.convertHandler(resultHandler, ar -> ar.map(event -> (T)TypeArg.of(clientClass).wrap(event)))));
    return ret;
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * @param discovery the service discovery
   * @param filter the filter as json object
   * @param clientClass the client class
   * @param resultHandler the result handler
   * @return <code>null</code> - do not use
   */
  public static <T> T getServiceProxyWithJsonFilter(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, java.lang.Class<T> clientClass, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> resultHandler) { 
    T ret = (T)TypeArg.of(clientClass).wrap(io.vertx.servicediscovery.types.EventBusService.getServiceProxyWithJsonFilter(discovery.getDelegate(), filter, io.vertx.lang.reactivex.Helper.unwrap(clientClass), io.vertx.lang.reactivex.Helper.convertHandler(resultHandler, ar -> ar.map(event -> (T)TypeArg.of(clientClass).wrap(event)))));
    return ret;
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * @param discovery the service discovery
   * @param filter the filter as json object
   * @param clientClass the client class
   * @param conf the configuration for message delivery
   * @param resultHandler the result handler
   * @return <code>null</code> - do not use
   */
  public static <T> T getServiceProxyWithJsonFilter(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, java.lang.Class<T> clientClass, io.vertx.core.json.JsonObject conf, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> resultHandler) { 
    T ret = (T)TypeArg.of(clientClass).wrap(io.vertx.servicediscovery.types.EventBusService.getServiceProxyWithJsonFilter(discovery.getDelegate(), filter, io.vertx.lang.reactivex.Helper.unwrap(clientClass), conf, io.vertx.lang.reactivex.Helper.convertHandler(resultHandler, ar -> ar.map(event -> (T)TypeArg.of(clientClass).wrap(event)))));
    return ret;
  }

  /**
   * Creates a record based on the parameters.
   * @param name the service name
   * @param address the address
   * @param classname the payload class
   * @return the record
   */
  public static io.vertx.servicediscovery.Record createRecord(java.lang.String name, java.lang.String address, java.lang.String classname) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.EventBusService.createRecord(name, address, classname);
    return ret;
  }

  /**
   * Unknown type.
   */
  public static final java.lang.String UNKNOWN = io.vertx.servicediscovery.types.EventBusService.UNKNOWN;
  /**
   * Name of the type.
   */
  public static final java.lang.String TYPE = io.vertx.servicediscovery.types.EventBusService.TYPE;
  public static EventBusService newInstance(io.vertx.servicediscovery.types.EventBusService arg) {
    return arg != null ? new EventBusService(arg) : null;
  }

}
