/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.system;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A job executed in a {@link io.vertx.reactivex.ext.shell.system.JobController}, grouping one or several process.<p/>
 *
 * The job life cycle can be controlled with the {@link io.vertx.reactivex.ext.shell.system.Job#run}, {@link io.vertx.reactivex.ext.shell.system.Job#resume} and {@link io.vertx.reactivex.ext.shell.system.Job#suspend} and {@link io.vertx.reactivex.ext.shell.system.Job#interrupt}
 * methods.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.system.Job original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.system.Job.class)
public class Job implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Job that = (Job) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Job> __TYPE_ARG = new TypeArg<>(    obj -> new Job((io.vertx.ext.shell.system.Job) obj),
    Job::getDelegate
  );

  private final io.vertx.ext.shell.system.Job delegate;
  
  public Job(io.vertx.ext.shell.system.Job delegate) {
    this.delegate = delegate;
  }

  public Job(Object delegate) {
    this.delegate = (io.vertx.ext.shell.system.Job)delegate;
  }

  @Override 
  public io.vertx.ext.shell.system.Job getDelegate() {
    return delegate;
  }

  /**
   * @return the job id
   */
  public int id() { 
    int ret = delegate.id();
    return ret;
  }

  /**
   * @return the job exec status
   */
  public io.vertx.ext.shell.system.ExecStatus status() { 
    io.vertx.ext.shell.system.ExecStatus ret = delegate.status();
    return ret;
  }

  /**
   * @return when the job was last stopped
   */
  public long lastStopped() { 
    long ret = delegate.lastStopped();
    return ret;
  }

  /**
   * @return the execution line of the job, i.e the shell command line that launched this job
   */
  public java.lang.String line() { 
    java.lang.String ret = delegate.line();
    return ret;
  }

  /**
   * Set a tty on the job.
   * @param tty the tty to use
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.system.Job setTty(io.vertx.reactivex.ext.shell.term.Tty tty) { 
    delegate.setTty(tty.getDelegate());
    return this;
  }

  /**
   * Set a session on the job.
   * @param session the session to use
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.system.Job setSession(io.vertx.reactivex.ext.shell.session.Session session) { 
    delegate.setSession(session.getDelegate());
    return this;
  }

  /**
   * Set an handler called when the job terminates.
   * @param handler the terminate handler
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.system.Job statusUpdateHandler(io.vertx.core.Handler<io.vertx.ext.shell.system.ExecStatus> handler) { 
    delegate.statusUpdateHandler(handler);
    return this;
  }

  /**
   * Run the job, before running the job a  must be set.
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.system.Job run() { 
    delegate.run();
    return this;
  }

  /**
   * Attempt to interrupt the job.
   * @return true if the job is actually interrupted
   */
  public boolean interrupt() { 
    boolean ret = delegate.interrupt();
    return ret;
  }

  /**
   * Resume the job to foreground.
   * @return 
   */
  public io.vertx.reactivex.ext.shell.system.Job resume() { 
    io.vertx.reactivex.ext.shell.system.Job ret = io.vertx.reactivex.ext.shell.system.Job.newInstance((io.vertx.ext.shell.system.Job)delegate.resume());
    return ret;
  }

  /**
   * Send the job to background.
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.system.Job toBackground() { 
    delegate.toBackground();
    return this;
  }

  /**
   * Send the job to foreground.
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.system.Job toForeground() { 
    delegate.toForeground();
    return this;
  }

  /**
   * Resume the job.
   * @param foreground true when the job is resumed in foreground
   * @return 
   */
  public io.vertx.reactivex.ext.shell.system.Job resume(boolean foreground) { 
    delegate.resume(foreground);
    return this;
  }

  /**
   * Resume the job.
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.system.Job suspend() { 
    delegate.suspend();
    return this;
  }

  /**
   * Terminate the job.
   */
  public void terminate() { 
    delegate.terminate();
  }

  /**
   * @return the first process in the job
   */
  public io.vertx.reactivex.ext.shell.system.Process process() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.ext.shell.system.Process ret = io.vertx.reactivex.ext.shell.system.Process.newInstance((io.vertx.ext.shell.system.Process)delegate.process());
    cached_0 = ret;
    return ret;
  }

  private io.vertx.reactivex.ext.shell.system.Process cached_0;
  public static Job newInstance(io.vertx.ext.shell.system.Job arg) {
    return arg != null ? new Job(arg) : null;
  }

}
