/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.webauthn;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating WebAuthN based {@link io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.webauthn.WebAuthn original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.webauthn.WebAuthn.class)
public class WebAuthn extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebAuthn that = (WebAuthn) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebAuthn> __TYPE_ARG = new TypeArg<>(    obj -> new WebAuthn((io.vertx.ext.auth.webauthn.WebAuthn) obj),
    WebAuthn::getDelegate
  );

  private final io.vertx.ext.auth.webauthn.WebAuthn delegate;
  
  public WebAuthn(io.vertx.ext.auth.webauthn.WebAuthn delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public WebAuthn(Object delegate) {
    super((io.vertx.ext.auth.webauthn.WebAuthn)delegate);
    this.delegate = (io.vertx.ext.auth.webauthn.WebAuthn)delegate;
  }

  @Override 
  public io.vertx.ext.auth.webauthn.WebAuthn getDelegate() {
    return delegate;
  }

  /**
   * Create a WebAuthN auth provider
   * @param vertx the Vertx instance.
   * @return the auth provider.
   */
  public static io.vertx.reactivex.ext.auth.webauthn.WebAuthn create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.auth.webauthn.WebAuthn ret = io.vertx.reactivex.ext.auth.webauthn.WebAuthn.newInstance((io.vertx.ext.auth.webauthn.WebAuthn)io.vertx.ext.auth.webauthn.WebAuthn.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a WebAuthN auth provider
   * @param vertx the Vertx instance.
   * @param options the custom options to the provider.
   * @return the auth provider.
   */
  public static io.vertx.reactivex.ext.auth.webauthn.WebAuthn create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.webauthn.WebAuthnOptions options) { 
    io.vertx.reactivex.ext.auth.webauthn.WebAuthn ret = io.vertx.reactivex.ext.auth.webauthn.WebAuthn.newInstance((io.vertx.ext.auth.webauthn.WebAuthn)io.vertx.ext.auth.webauthn.WebAuthn.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Gets a challenge and any other parameters for the <code>navigator.credentials.create()</code> call.
   *
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param user - the user object with name and optionally displayName and icon
   * @param handler server encoded make credentials request
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.webauthn.WebAuthn createCredentialsOptions(io.vertx.core.json.JsonObject user, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> handler) { 
    delegate.createCredentialsOptions(user, handler);
    return this;
  }

  /**
   * Gets a challenge and any other parameters for the <code>navigator.credentials.create()</code> call.
   *
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param user - the user object with name and optionally displayName and icon
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.webauthn.WebAuthn createCredentialsOptions(io.vertx.core.json.JsonObject user) {
    return 
createCredentialsOptions(user, ar -> { });
  }

  /**
   * Gets a challenge and any other parameters for the <code>navigator.credentials.create()</code> call.
   *
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param user - the user object with name and optionally displayName and icon
   * @return fluent self
   */
  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxCreateCredentialsOptions(io.vertx.core.json.JsonObject user) { 
    return AsyncResultSingle.toSingle($handler -> {
      createCredentialsOptions(user, $handler);
    });
  }

  /**
   * Creates an assertion challenge and any other parameters for the <code>navigator.credentials.get()</code> call.
   * If the auth provider is configured with <code>RequireResidentKey</code> and the username is null then the
   * generated assertion will be a RK assertion (Usernameless).
   *
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param name the unique user identified
   * @param handler server encoded get assertion request
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.webauthn.WebAuthn getCredentialsOptions(java.lang.String name, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonObject>> handler) { 
    delegate.getCredentialsOptions(name, handler);
    return this;
  }

  /**
   * Creates an assertion challenge and any other parameters for the <code>navigator.credentials.get()</code> call.
   * If the auth provider is configured with <code>RequireResidentKey</code> and the username is null then the
   * generated assertion will be a RK assertion (Usernameless).
   *
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param name the unique user identified
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.webauthn.WebAuthn getCredentialsOptions(java.lang.String name) {
    return 
getCredentialsOptions(name, ar -> { });
  }

  /**
   * Creates an assertion challenge and any other parameters for the <code>navigator.credentials.get()</code> call.
   * If the auth provider is configured with <code>RequireResidentKey</code> and the username is null then the
   * generated assertion will be a RK assertion (Usernameless).
   *
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param name the unique user identified
   * @return fluent self.
   */
  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxGetCredentialsOptions(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      getCredentialsOptions(name, $handler);
    });
  }

  /**
   * Provide a  that can fetch {@link io.vertx.ext.auth.webauthn.Authenticator}s from a backend given the incomplete
   * {@link io.vertx.ext.auth.webauthn.Authenticator} argument.
   *
   * The implementation must consider the following fields <strong>exclusively</strong>, while performing the lookup:
   * <ul>
   *   <li>{@link io.vertx.ext.auth.webauthn.Authenticator}</li>
   *   <li>{@link io.vertx.ext.auth.webauthn.Authenticator} ()}</li>
   * </ul>
   *
   * It may return more than 1 result, for example when a user can be identified using different modalities.
   * To signal that a user is not allowed/present on the system, a failure should be returned, not <code>null</code>.
   *
   * The function signature is as follows:
   *
   * <code>(Authenticator) -> Future<List<Authenticator>>></code>
   *
   * <ul>
   *   <li>{@link io.vertx.ext.auth.webauthn.Authenticator} the incomplete authenticator data to lookup.</li>
   *   <li>async result with a list of authenticators.</li>
   * </ul>
   * @param fetcher fetcher function.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.webauthn.WebAuthn authenticatorFetcher(java.util.function.Function<io.vertx.ext.auth.webauthn.Authenticator,io.vertx.core.Future<java.util.List<io.vertx.ext.auth.webauthn.Authenticator>>> fetcher) { 
    delegate.authenticatorFetcher(new Function<io.vertx.ext.auth.webauthn.Authenticator,io.vertx.core.Future<java.util.List<io.vertx.ext.auth.webauthn.Authenticator>>>() {
      public io.vertx.core.Future<java.util.List<io.vertx.ext.auth.webauthn.Authenticator>> apply(io.vertx.ext.auth.webauthn.Authenticator arg) {
        io.vertx.core.Future<java.util.List<io.vertx.ext.auth.webauthn.Authenticator>> ret = fetcher.apply(arg);
        return ret.map(val -> val);
      }
    });
    return this;
  }

  /**
   * Provide a  that can fetch {@link io.vertx.ext.auth.webauthn.Authenticator}s from a backend given the incomplete
   * {@link io.vertx.ext.auth.webauthn.Authenticator} argument.
   *
   * The implementation must consider the following fields <strong>exclusively</strong>, while performing the lookup:
   * <ul>
   *   <li>{@link io.vertx.ext.auth.webauthn.Authenticator}</li>
   *   <li>{@link io.vertx.ext.auth.webauthn.Authenticator} ()}</li>
   * </ul>
   *
   * It may return more than 1 result, for example when a user can be identified using different modalities.
   * To signal that a user is not allowed/present on the system, a failure should be returned, not <code>null</code>.
   *
   * The function signature is as follows:
   *
   * <code>(Authenticator) -> Future<List<Authenticator>>></code>
   *
   * <ul>
   *   <li>{@link io.vertx.ext.auth.webauthn.Authenticator} the incomplete authenticator data to lookup.</li>
   *   <li>async result with a list of authenticators.</li>
   * </ul>
   * @param fetcher fetcher function.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.webauthn.WebAuthn authenticatorFetcher(io.reactivex.functions.Function<io.vertx.ext.auth.webauthn.Authenticator,io.reactivex.Single<java.util.List<io.vertx.ext.auth.webauthn.Authenticator>>> fetcher) { 
    delegate.authenticatorFetcher(new Function<io.vertx.ext.auth.webauthn.Authenticator,io.vertx.core.Future<java.util.List<io.vertx.ext.auth.webauthn.Authenticator>>>() {
      public io.vertx.core.Future<java.util.List<io.vertx.ext.auth.webauthn.Authenticator>> apply(io.vertx.ext.auth.webauthn.Authenticator arg) {
        io.reactivex.Single<java.util.List<io.vertx.ext.auth.webauthn.Authenticator>> ret;
        try {
          ret = fetcher.apply(arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj);
      }
    });
    return this;
  }

  /**
   * Provide a  that can update or insert a {@link io.vertx.ext.auth.webauthn.Authenticator}.
   * The function <strong>should</strong> store a given authenticator to a persistence storage.
   *
   * When an authenticator is already present, this method <strong>must</strong> at least update
   * {@link io.vertx.ext.auth.webauthn.Authenticator}, and is not required to perform any other update.
   *
   * For new authenticators, the whole object data <strong>must</strong> be persisted.
   *
   * The function signature is as follows:
   *
   * <code>(Authenticator) -> Future<Void></code>
   *
   * <ul>
   *   <li>{@link io.vertx.ext.auth.webauthn.Authenticator} the authenticator data to update.</li>
   *   <li>async result of the operation.</li>
   * </ul>
   * @param updater updater function.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.webauthn.WebAuthn authenticatorUpdater(java.util.function.Function<io.vertx.ext.auth.webauthn.Authenticator,io.vertx.core.Future<java.lang.Void>> updater) { 
    delegate.authenticatorUpdater(new Function<io.vertx.ext.auth.webauthn.Authenticator,io.vertx.core.Future<java.lang.Void>>() {
      public io.vertx.core.Future<java.lang.Void> apply(io.vertx.ext.auth.webauthn.Authenticator arg) {
        io.vertx.core.Future<java.lang.Void> ret = updater.apply(arg);
        return ret.map(val -> val);
      }
    });
    return this;
  }

  /**
   * Provide a  that can update or insert a {@link io.vertx.ext.auth.webauthn.Authenticator}.
   * The function <strong>should</strong> store a given authenticator to a persistence storage.
   *
   * When an authenticator is already present, this method <strong>must</strong> at least update
   * {@link io.vertx.ext.auth.webauthn.Authenticator}, and is not required to perform any other update.
   *
   * For new authenticators, the whole object data <strong>must</strong> be persisted.
   *
   * The function signature is as follows:
   *
   * <code>(Authenticator) -> Future<Void></code>
   *
   * <ul>
   *   <li>{@link io.vertx.ext.auth.webauthn.Authenticator} the authenticator data to update.</li>
   *   <li>async result of the operation.</li>
   * </ul>
   * @param updater updater function.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.webauthn.WebAuthn authenticatorUpdater(io.reactivex.functions.Function<io.vertx.ext.auth.webauthn.Authenticator,io.reactivex.Completable> updater) { 
    delegate.authenticatorUpdater(new Function<io.vertx.ext.auth.webauthn.Authenticator,io.vertx.core.Future<Void>>() {
      public io.vertx.core.Future<Void> apply(io.vertx.ext.auth.webauthn.Authenticator arg) {
        io.reactivex.Completable ret;
        try {
          ret = updater.apply(arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.CompletableHelper.toFuture(ret);
      }
    });
    return this;
  }

  /**
   * Getter to the instance FIDO2 Meta Data Service.
   * @return the MDS instance.
   */
  public io.vertx.reactivex.ext.auth.webauthn.MetaDataService metaDataService() { 
    io.vertx.reactivex.ext.auth.webauthn.MetaDataService ret = io.vertx.reactivex.ext.auth.webauthn.MetaDataService.newInstance((io.vertx.ext.auth.webauthn.MetaDataService)delegate.metaDataService());
    return ret;
  }

  public static WebAuthn newInstance(io.vertx.ext.auth.webauthn.WebAuthn arg) {
    return arg != null ? new WebAuthn(arg) : null;
  }

}
