/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a server side WebSocket.
 * <p>
 * Instances of this class are passed into a {@link io.vertx.reactivex.core.http.HttpServer#webSocketHandler} or provided
 * when a WebSocket handshake is manually {@link io.vertx.reactivex.core.http.HttpServerRequest#toWebSocket}ed.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.ServerWebSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.ServerWebSocket.class)
public class ServerWebSocket implements RxDelegate, io.vertx.reactivex.core.http.WebSocketBase {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerWebSocket that = (ServerWebSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServerWebSocket> __TYPE_ARG = new TypeArg<>(    obj -> new ServerWebSocket((io.vertx.core.http.ServerWebSocket) obj),
    ServerWebSocket::getDelegate
  );

  private final io.vertx.core.http.ServerWebSocket delegate;
  
  public ServerWebSocket(io.vertx.core.http.ServerWebSocket delegate) {
    this.delegate = delegate;
  }

  public ServerWebSocket(Object delegate) {
    this.delegate = (io.vertx.core.http.ServerWebSocket)delegate;
  }

  @Override 
  public io.vertx.core.http.ServerWebSocket getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
  private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
    pipeTo(dst, ar -> { });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      pipeTo(dst, $handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(io.vertx.reactivex.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(io.vertx.reactivex.core.buffer.Buffer data) {
    write(data, ar -> { });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      write(data, $handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data) {
    end(data, ar -> { });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      end(data, $handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.core.http.ServerWebSocket#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * When a <code>WebSocket</code> is created, it may register an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * By default, no handler is registered, the feature must be enabled via {@link io.vertx.core.http.WebSocketConnectOptions} or {@link io.vertx.core.http.HttpServerOptions}.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public java.lang.String binaryHandlerID() { 
    java.lang.String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * When a <code>WebSocket</code> is created, it may register an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * By default, no handler is registered, the feature must be enabled via {@link io.vertx.core.http.WebSocketConnectOptions} or {@link io.vertx.core.http.HttpServerOptions}.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the text handler id
   */
  public java.lang.String textHandlerID() { 
    java.lang.String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * Returns the WebSocket sub protocol selected by the WebSocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the WebSocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public java.lang.String subProtocol() { 
    java.lang.String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * Returns the close status code received from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public java.lang.Short closeStatusCode() { 
    java.lang.Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * Returns the close reason message from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public java.lang.String closeReason() { 
    java.lang.String ret = delegate.closeReason();
    return ret;
  }

  /**
   *  Returns the HTTP headers when the WebSocket is first obtained in the handler.
   *  <p/>
   *  The headers will be <code>null</code> on subsequent interactions.
   * @return the headers
   */
  public io.vertx.reactivex.core.MultiMap headers() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * {@link io.vertx.reactivex.core.http.WebSocketBase#binaryMessageHandler}, but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.WebSocketBase textMessageHandler(io.vertx.core.Handler<java.lang.String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.reactivex.core.http.ServerWebSocket#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.reactivex.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.WebSocketBase binaryMessageHandler(io.vertx.core.Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.binaryMessageHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.WebSocketBase pongHandler(io.vertx.core.Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.pongHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * 
   *
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#close}
   * @param handler 
   */
  public void end(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * 
   *
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#close}
   */
  public void end() {
    end(ar -> { });
  }

  /**
   * 
   *
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#close}
   * @return 
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      end($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.ServerWebSocket#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.ServerWebSocket#close} but with an <code>handler</code> called when the operation completes
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.ServerWebSocket#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param handler 
   */
  public void close(short statusCode, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(statusCode, handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   */
  public void close(short statusCode) {
    close(statusCode, ar -> { });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @return 
   */
  public io.reactivex.Completable rxClose(short statusCode) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close(statusCode, $handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  public void close(short statusCode, java.lang.String reason, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(statusCode, reason, handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   */
  public void close(short statusCode, java.lang.String reason) {
    close(statusCode, reason, ar -> { });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public io.reactivex.Completable rxClose(short statusCode, java.lang.String reason) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close(statusCode, reason, $handler);
    });
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.reactivex.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.reactivex.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.reactivex.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket handler(io.vertx.core.Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.handler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeFrame(io.vertx.reactivex.core.http.WebSocketFrame frame, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeFrame(frame.getDelegate(), handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeFrame(io.vertx.reactivex.core.http.WebSocketFrame frame) {
    return 
writeFrame(frame, ar -> { });
  }

  public io.reactivex.Completable rxWriteFrame(io.vertx.reactivex.core.http.WebSocketFrame frame) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      writeFrame(frame, $handler);
    });
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeFinalTextFrame(java.lang.String text, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeFinalTextFrame(text, handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeFinalTextFrame(java.lang.String text) {
    return 
writeFinalTextFrame(text, ar -> { });
  }

  public io.reactivex.Completable rxWriteFinalTextFrame(java.lang.String text) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      writeFinalTextFrame(text, $handler);
    });
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) {
    return 
writeFinalBinaryFrame(data, ar -> { });
  }

  public io.reactivex.Completable rxWriteFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      writeFinalBinaryFrame(data, $handler);
    });
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeBinaryMessage(data.getDelegate(), handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) {
    return 
writeBinaryMessage(data, ar -> { });
  }

  public io.reactivex.Completable rxWriteBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      writeBinaryMessage(data, $handler);
    });
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeTextMessage(java.lang.String text, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writeTextMessage(text, handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writeTextMessage(java.lang.String text) {
    return 
writeTextMessage(text, ar -> { });
  }

  public io.reactivex.Completable rxWriteTextMessage(java.lang.String text) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      writeTextMessage(text, $handler);
    });
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writePing(io.vertx.reactivex.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writePing(data.getDelegate(), handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writePing(io.vertx.reactivex.core.buffer.Buffer data) {
    return 
writePing(data, ar -> { });
  }

  public io.reactivex.Completable rxWritePing(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      writePing(data, $handler);
    });
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writePong(io.vertx.reactivex.core.buffer.Buffer data, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.writePong(data.getDelegate(), handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket writePong(io.vertx.reactivex.core.buffer.Buffer data) {
    return 
writePong(data, ar -> { });
  }

  public io.reactivex.Completable rxWritePong(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      writePong(data, $handler);
    });
  }

  public io.vertx.reactivex.core.http.ServerWebSocket closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket frameHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)event)));
    return this;
  }

  /**
   * @return the WebSocket handshake scheme
   */
  public java.lang.String scheme() { 
    java.lang.String ret = delegate.scheme();
    return ret;
  }

  /**
   * @return the WebSocket handshake host
   */
  @Deprecated()
  public java.lang.String host() { 
    java.lang.String ret = delegate.host();
    return ret;
  }

  /**
   * @return the WebSocket handshake authority
   */
  public io.vertx.reactivex.core.net.HostAndPort authority() { 
    io.vertx.reactivex.core.net.HostAndPort ret = io.vertx.reactivex.core.net.HostAndPort.newInstance((io.vertx.core.net.HostAndPort)delegate.authority());
    return ret;
  }

  public java.lang.String uri() { 
    java.lang.String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the WebSocket handshake path.
   */
  public java.lang.String path() { 
    java.lang.String ret = delegate.path();
    return ret;
  }

  /**
   * @return the WebSocket handshake query string.
   */
  public java.lang.String query() { 
    java.lang.String ret = delegate.query();
    return ret;
  }

  /**
   * Accept the WebSocket and terminate the WebSocket handshake.
   * <p/>
   * This method should be called from the WebSocket handler to explicitly accept the WebSocket and
   * terminate the WebSocket handshake.
   */
  @Deprecated()
  public void accept() { 
    delegate.accept();
  }

  /**
   * Reject the WebSocket.
   * <p>
   * Calling this method from the WebSocket handler when it is first passed to you gives you the opportunity to reject
   * the WebSocket, which will cause the WebSocket handshake to fail by returning
   * a  response code.
   * <p>
   * You might use this method, if for example you only want to accept WebSockets with a particular path.
   */
  @Deprecated()
  public void reject() { 
    delegate.reject();
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.ServerWebSocket#reject} but with a <code>status</code>.
   * @param status 
   */
  @Deprecated()
  public void reject(int status) { 
    delegate.reject(status);
  }

  /**
   * Set an asynchronous result for the handshake, upon completion of the specified <code>future</code>, the
   * WebSocket will either be
   *
   * <ul>
   *   <li>accepted when the <code>future</code> succeeds with the HTTP  status code</li>
   *   <li>rejected when the <code>future</code> is succeeds with an HTTP status code different than </li>
   *   <li>rejected when the <code>future</code> fails with the HTTP status code <code>500</code></li>
   * </ul>
   *
   * The provided future might be completed by the WebSocket itself, e.g calling the {@link io.vertx.reactivex.core.http.ServerWebSocket#close} method
   * will try to accept the handshake and close the WebSocket afterward. Thus it is advised to try to complete
   * the <code>future</code> with  or .
   * <p>
   * This method should be called from the WebSocket handler to explicitly set an asynchronous handshake.
   * <p>
   * Calling this method will override the <code>future</code> completion handler.
   * @param future the future to complete with
   * @param handler the completion handler
   */
  @Deprecated()
  public void setHandshake(io.vertx.core.Future<java.lang.Integer> future, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Integer>> handler) { 
    delegate.setHandshake(future.map(val -> val), handler);
  }

  /**
   * Set an asynchronous result for the handshake, upon completion of the specified <code>future</code>, the
   * WebSocket will either be
   *
   * <ul>
   *   <li>accepted when the <code>future</code> succeeds with the HTTP  status code</li>
   *   <li>rejected when the <code>future</code> is succeeds with an HTTP status code different than </li>
   *   <li>rejected when the <code>future</code> fails with the HTTP status code <code>500</code></li>
   * </ul>
   *
   * The provided future might be completed by the WebSocket itself, e.g calling the {@link io.vertx.reactivex.core.http.ServerWebSocket#close} method
   * will try to accept the handshake and close the WebSocket afterward. Thus it is advised to try to complete
   * the <code>future</code> with  or .
   * <p>
   * This method should be called from the WebSocket handler to explicitly set an asynchronous handshake.
   * <p>
   * Calling this method will override the <code>future</code> completion handler.
   * @param future the future to complete with
   */
  @Deprecated()
  public void setHandshake(io.vertx.core.Future<java.lang.Integer> future) {
    setHandshake(future, ar -> { });
  }

  /**
   * Set an asynchronous result for the handshake, upon completion of the specified <code>future</code>, the
   * WebSocket will either be
   *
   * <ul>
   *   <li>accepted when the <code>future</code> succeeds with the HTTP  status code</li>
   *   <li>rejected when the <code>future</code> is succeeds with an HTTP status code different than </li>
   *   <li>rejected when the <code>future</code> fails with the HTTP status code <code>500</code></li>
   * </ul>
   *
   * The provided future might be completed by the WebSocket itself, e.g calling the {@link io.vertx.reactivex.core.http.ServerWebSocket#close} method
   * will try to accept the handshake and close the WebSocket afterward. Thus it is advised to try to complete
   * the <code>future</code> with  or .
   * <p>
   * This method should be called from the WebSocket handler to explicitly set an asynchronous handshake.
   * <p>
   * Calling this method will override the <code>future</code> completion handler.
   * @param future the future to complete with
   * @return 
   */
  @Deprecated()
  public io.reactivex.Single<java.lang.Integer> rxSetHandshake(io.vertx.core.Future<java.lang.Integer> future) { 
    return AsyncResultSingle.toSingle($handler -> {
      setHandshake(future, $handler);
    });
  }

  /**
   * Set an asynchronous result for the handshake, upon completion of the specified <code>future</code>, the
   * WebSocket will either be
   *
   * <ul>
   *   <li>accepted when the <code>future</code> succeeds with the HTTP  status code</li>
   *   <li>rejected when the <code>future</code> is succeeds with an HTTP status code different than </li>
   *   <li>rejected when the <code>future</code> fails with the HTTP status code <code>500</code></li>
   * </ul>
   *
   * The provided future might be completed by the WebSocket itself, e.g calling the {@link io.vertx.reactivex.core.http.ServerWebSocket#close} method
   * will try to accept the handshake and close the WebSocket afterward. Thus it is advised to try to complete
   * the <code>future</code> with  or .
   * <p>
   * This method should be called from the WebSocket handler to explicitly set an asynchronous handshake.
   * <p>
   * Calling this method will override the <code>future</code> completion handler.
   * @param future the future to complete with
   * @param handler the completion handler
   */
  @Deprecated()
  public void setHandshake(io.reactivex.Single<java.lang.Integer> future, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Integer>> handler) { 
    delegate.setHandshake(io.vertx.reactivex.SingleHelper.toFuture(future, obj -> obj), handler);
  }

  /**
   * Set an asynchronous result for the handshake, upon completion of the specified <code>future</code>, the
   * WebSocket will either be
   *
   * <ul>
   *   <li>accepted when the <code>future</code> succeeds with the HTTP  status code</li>
   *   <li>rejected when the <code>future</code> is succeeds with an HTTP status code different than </li>
   *   <li>rejected when the <code>future</code> fails with the HTTP status code <code>500</code></li>
   * </ul>
   *
   * The provided future might be completed by the WebSocket itself, e.g calling the {@link io.vertx.reactivex.core.http.ServerWebSocket#close} method
   * will try to accept the handshake and close the WebSocket afterward. Thus it is advised to try to complete
   * the <code>future</code> with  or .
   * <p>
   * This method should be called from the WebSocket handler to explicitly set an asynchronous handshake.
   * <p>
   * Calling this method will override the <code>future</code> completion handler.
   * @param future the future to complete with
   */
  @Deprecated()
  public void setHandshake(io.reactivex.Single<java.lang.Integer> future) {
    setHandshake(future, ar -> { });
  }

  /**
   * Set an asynchronous result for the handshake, upon completion of the specified <code>future</code>, the
   * WebSocket will either be
   *
   * <ul>
   *   <li>accepted when the <code>future</code> succeeds with the HTTP  status code</li>
   *   <li>rejected when the <code>future</code> is succeeds with an HTTP status code different than </li>
   *   <li>rejected when the <code>future</code> fails with the HTTP status code <code>500</code></li>
   * </ul>
   *
   * The provided future might be completed by the WebSocket itself, e.g calling the {@link io.vertx.reactivex.core.http.ServerWebSocket#close} method
   * will try to accept the handshake and close the WebSocket afterward. Thus it is advised to try to complete
   * the <code>future</code> with  or .
   * <p>
   * This method should be called from the WebSocket handler to explicitly set an asynchronous handshake.
   * <p>
   * Calling this method will override the <code>future</code> completion handler.
   * @param future the future to complete with
   * @return 
   */
  @Deprecated()
  public io.reactivex.Single<java.lang.Integer> rxSetHandshake(io.reactivex.Single<java.lang.Integer> future) { 
    return AsyncResultSingle.toSingle($handler -> {
      setHandshake(future, $handler);
    });
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.reactivex.core.net.SocketAddress cached_0;
  private io.vertx.reactivex.core.net.SocketAddress cached_1;
  public static ServerWebSocket newInstance(io.vertx.core.http.ServerWebSocket arg) {
    return arg != null ? new ServerWebSocket(arg) : null;
  }

}
