/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.mongo;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.GridFsDownloadOptions;
import io.vertx.ext.mongo.GridFsUploadOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.ReadStreamSubscriber;
import java.util.List;

@RxGen(value=io.vertx.ext.mongo.MongoGridFsClient.class)
public class MongoGridFsClient
implements RxDelegate {
    public static final TypeArg<MongoGridFsClient> __TYPE_ARG = new TypeArg(obj -> new MongoGridFsClient((io.vertx.ext.mongo.MongoGridFsClient)obj), MongoGridFsClient::getDelegate);
    private final io.vertx.ext.mongo.MongoGridFsClient delegate;
    private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_2 = new TypeArg(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoGridFsClient that = (MongoGridFsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoGridFsClient(io.vertx.ext.mongo.MongoGridFsClient delegate) {
        this.delegate = delegate;
    }

    public MongoGridFsClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoGridFsClient)delegate;
    }

    public io.vertx.ext.mongo.MongoGridFsClient getDelegate() {
        return this.delegate;
    }

    public MongoGridFsClient delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.delete(id, resultHandler);
        return this;
    }

    public MongoGridFsClient delete(String id) {
        return this.delete(id, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxDelete(String id) {
        return AsyncResultCompletable.toCompletable($handler -> this.delete(id, (Handler<AsyncResult<Void>>)$handler));
    }

    public ReadStream<io.vertx.reactivex.core.buffer.Buffer> readByFileName(String fileName) {
        ReadStream<io.vertx.reactivex.core.buffer.Buffer> ret = ReadStream.newInstance(this.delegate.readByFileName(fileName), TYPE_ARG_0);
        return ret;
    }

    public ReadStream<io.vertx.reactivex.core.buffer.Buffer> readByFileNameWithOptions(String fileName, GridFsDownloadOptions options) {
        ReadStream<io.vertx.reactivex.core.buffer.Buffer> ret = ReadStream.newInstance(this.delegate.readByFileNameWithOptions(fileName, options), TYPE_ARG_1);
        return ret;
    }

    public ReadStream<io.vertx.reactivex.core.buffer.Buffer> readById(String id) {
        ReadStream<io.vertx.reactivex.core.buffer.Buffer> ret = ReadStream.newInstance(this.delegate.readById(id), TYPE_ARG_2);
        return ret;
    }

    public MongoGridFsClient downloadByFileName(WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadByFileName(stream.getDelegate(), fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadByFileName(WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName) {
        return this.downloadByFileName(stream, fileName, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadByFileName(WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.downloadByFileName(stream, fileName, (Handler<AsyncResult<Long>>)$handler));
    }

    public MongoGridFsClient downloadByFileNameWithOptions(WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, GridFsDownloadOptions options, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadByFileNameWithOptions(WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, GridFsDownloadOptions options) {
        return this.downloadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadByFileNameWithOptions(WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, GridFsDownloadOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.downloadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<Long>>)$handler));
    }

    public MongoGridFsClient downloadById(WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, String id, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadById(stream.getDelegate(), id, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadById(WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, String id) {
        return this.downloadById(stream, id, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadById(WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, String id) {
        return AsyncResultSingle.toSingle($handler -> this.downloadById(stream, id, (Handler<AsyncResult<Long>>)$handler));
    }

    public MongoGridFsClient downloadFile(String fileName, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadFile(fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadFile(String fileName) {
        return this.downloadFile(fileName, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadFile(String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.downloadFile(fileName, (Handler<AsyncResult<Long>>)$handler));
    }

    public MongoGridFsClient downloadFileAs(String fileName, String newFileName, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadFileAs(fileName, newFileName, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadFileAs(String fileName, String newFileName) {
        return this.downloadFileAs(fileName, newFileName, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadFileAs(String fileName, String newFileName) {
        return AsyncResultSingle.toSingle($handler -> this.downloadFileAs(fileName, newFileName, (Handler<AsyncResult<Long>>)$handler));
    }

    public MongoGridFsClient downloadFileByID(String id, String fileName, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadFileByID(id, fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadFileByID(String id, String fileName) {
        return this.downloadFileByID(id, fileName, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadFileByID(String id, String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.downloadFileByID(id, fileName, (Handler<AsyncResult<Long>>)$handler));
    }

    public MongoGridFsClient drop(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.drop(resultHandler);
        return this;
    }

    public MongoGridFsClient drop() {
        return this.drop((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxDrop() {
        return AsyncResultCompletable.toCompletable($handler -> this.drop((Handler<AsyncResult<Void>>)$handler));
    }

    public MongoGridFsClient findAllIds(Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.findAllIds(resultHandler);
        return this;
    }

    public MongoGridFsClient findAllIds() {
        return this.findAllIds((Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxFindAllIds() {
        return AsyncResultSingle.toSingle($handler -> this.findAllIds((Handler<AsyncResult<List<String>>>)$handler));
    }

    public MongoGridFsClient findIds(JsonObject query, Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.findIds(query, resultHandler);
        return this;
    }

    public MongoGridFsClient findIds(JsonObject query) {
        return this.findIds(query, (Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxFindIds(JsonObject query) {
        return AsyncResultSingle.toSingle($handler -> this.findIds(query, (Handler<AsyncResult<List<String>>>)$handler));
    }

    public MongoGridFsClient uploadByFileName(ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadByFileName(stream.getDelegate(), fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadByFileName(ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName) {
        return this.uploadByFileName(stream, fileName, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadByFileName(ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.uploadByFileName(stream, fileName, (Handler<AsyncResult<String>>)$handler));
    }

    public MongoGridFsClient uploadByFileName(Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadByFileName(ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume(), fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadByFileName(Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName) {
        return this.uploadByFileName(stream, fileName, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadByFileName(Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.uploadByFileName(stream, fileName, (Handler<AsyncResult<String>>)$handler));
    }

    public MongoGridFsClient uploadByFileNameWithOptions(ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, GridFsUploadOptions options, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadByFileNameWithOptions(ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, GridFsUploadOptions options) {
        return this.uploadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadByFileNameWithOptions(ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.uploadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<String>>)$handler));
    }

    public MongoGridFsClient uploadByFileNameWithOptions(Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, GridFsUploadOptions options, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadByFileNameWithOptions(ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume(), fileName, options, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadByFileNameWithOptions(Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, GridFsUploadOptions options) {
        return this.uploadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadByFileNameWithOptions(Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.uploadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<String>>)$handler));
    }

    public MongoGridFsClient uploadFile(String fileName, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadFile(fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadFile(String fileName) {
        return this.uploadFile(fileName, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadFile(String fileName) {
        return AsyncResultSingle.toSingle($handler -> this.uploadFile(fileName, (Handler<AsyncResult<String>>)$handler));
    }

    public MongoGridFsClient uploadFileWithOptions(String fileName, GridFsUploadOptions options, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadFileWithOptions(fileName, options, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        return this.uploadFileWithOptions(fileName, options, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.uploadFileWithOptions(fileName, options, (Handler<AsyncResult<String>>)$handler));
    }

    public void close() {
        this.delegate.close();
    }

    public static MongoGridFsClient newInstance(io.vertx.ext.mongo.MongoGridFsClient arg) {
        return arg != null ? new MongoGridFsClient(arg) : null;
    }
}

