/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.auth.jwt;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.auth.jwt.JWTCredentials;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.auth.jwt.JWTAuth.class)
public class JWTAuth
extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider {
    public static final TypeArg<JWTAuth> __TYPE_ARG = new TypeArg(obj -> new JWTAuth((io.vertx.ext.auth.jwt.JWTAuth)obj), JWTAuth::getDelegate);
    private final io.vertx.ext.auth.jwt.JWTAuth delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTAuth that = (JWTAuth)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public JWTAuth(io.vertx.ext.auth.jwt.JWTAuth delegate) {
        super((AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public JWTAuth(Object delegate) {
        super((AuthenticationProvider)((io.vertx.ext.auth.jwt.JWTAuth)delegate));
        this.delegate = (io.vertx.ext.auth.jwt.JWTAuth)delegate;
    }

    public io.vertx.ext.auth.jwt.JWTAuth getDelegate() {
        return this.delegate;
    }

    public static JWTAuth create(io.vertx.reactivex.core.Vertx vertx, JWTAuthOptions config) {
        JWTAuth ret = JWTAuth.newInstance(io.vertx.ext.auth.jwt.JWTAuth.create((Vertx)vertx.getDelegate(), (JWTAuthOptions)config));
        return ret;
    }

    public void authenticate(JWTCredentials credentials, final Handler<AsyncResult<User>> handler) {
        this.delegate.authenticate(credentials, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.User>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.User> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)User.newInstance((io.vertx.ext.auth.User)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void authenticate(JWTCredentials credentials) {
        this.authenticate(credentials, (Handler<AsyncResult<User>>)((Handler)ar -> {}));
    }

    public Single<User> rxAuthenticate(JWTCredentials credentials) {
        return AsyncResultSingle.toSingle($handler -> this.authenticate(credentials, (Handler<AsyncResult<User>>)$handler));
    }

    public String generateToken(JsonObject claims, JWTOptions options) {
        String ret = this.delegate.generateToken(claims, options);
        return ret;
    }

    public String generateToken(JsonObject claims) {
        String ret = this.delegate.generateToken(claims);
        return ret;
    }

    public static JWTAuth newInstance(io.vertx.ext.auth.jwt.JWTAuth arg) {
        return arg != null ? new JWTAuth(arg) : null;
    }
}

