/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.Future;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.HttpClientResponse;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.HttpFrame;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClientRequest.class)
public class HttpClientRequest
extends Future<HttpClientResponse>
implements WriteStream<io.vertx.reactivex.core.buffer.Buffer> {
    public static final TypeArg<HttpClientRequest> __TYPE_ARG = new TypeArg(obj -> new HttpClientRequest((io.vertx.core.http.HttpClientRequest)obj), HttpClientRequest::getDelegate);
    private final io.vertx.core.http.HttpClientRequest delegate;
    private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;
    private MultiMap cached_0;
    private HttpConnection cached_1;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientRequest that = (HttpClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        super((io.vertx.core.Future)delegate);
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpClientRequest getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver(this.getDelegate(), conv);
        }
        return this.observer;
    }

    public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write((Object)data.getDelegate(), handler);
    }

    @Override
    public void write(io.vertx.reactivex.core.buffer.Buffer data) {
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Handler<AsyncResult<HttpClientResponse>> getHandler() {
        Handler<AsyncResult<HttpClientResponse>> ret = new Handler<AsyncResult<HttpClientResponse>>(){

            public void handle(AsyncResult<HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    HttpClientRequest.this.delegate.getHandler().handle((Object)io.vertx.core.Future.succeededFuture((Object)((HttpClientResponse)ar.result()).getDelegate()));
                } else {
                    HttpClientRequest.this.delegate.getHandler().handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        };
        return ret;
    }

    @Override
    public HttpClientResponse result() {
        HttpClientResponse ret = HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)this.delegate.result());
        return ret;
    }

    @Override
    public <U> Future<U> compose(final Function<HttpClientResponse, Future<U>> mapper) {
        Future ret = Future.newInstance(this.delegate.compose(new Function<io.vertx.core.http.HttpClientResponse, io.vertx.core.Future<U>>(){

            @Override
            public io.vertx.core.Future<U> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)mapper.apply(HttpClientResponse.newInstance(arg));
                return ret.getDelegate();
            }
        }), TypeArg.unknown());
        return ret;
    }

    @Override
    public <U> Future<U> map(final Function<HttpClientResponse, U> mapper) {
        Future ret = Future.newInstance(this.delegate.map(new Function<io.vertx.core.http.HttpClientResponse, U>(){

            @Override
            public U apply(io.vertx.core.http.HttpClientResponse arg) {
                Object ret = mapper.apply(HttpClientResponse.newInstance(arg));
                return ret;
            }
        }), TypeArg.unknown());
        return ret;
    }

    @Override
    public Future<HttpClientResponse> recover(final Function<Throwable, Future<HttpClientResponse>> mapper) {
        Future<HttpClientResponse> ret = Future.newInstance(this.delegate.recover((Function)new Function<Throwable, io.vertx.core.Future<io.vertx.core.http.HttpClientResponse>>(){

            @Override
            public io.vertx.core.Future<io.vertx.core.http.HttpClientResponse> apply(Throwable arg) {
                Future ret = (Future)mapper.apply(arg);
                return ret.getDelegate();
            }
        }), HttpClientResponse.__TYPE_ARG);
        return ret;
    }

    @Override
    public Future<HttpClientResponse> otherwise(final Function<Throwable, HttpClientResponse> mapper) {
        Future<HttpClientResponse> ret = Future.newInstance(this.delegate.otherwise((Function)new Function<Throwable, io.vertx.core.http.HttpClientResponse>(){

            @Override
            public io.vertx.core.http.HttpClientResponse apply(Throwable arg) {
                HttpClientResponse ret = (HttpClientResponse)mapper.apply(arg);
                return ret.getDelegate();
            }
        }), HttpClientResponse.__TYPE_ARG);
        return ret;
    }

    @Override
    public Future<HttpClientResponse> otherwise(HttpClientResponse value) {
        Future<HttpClientResponse> ret = Future.newInstance(this.delegate.otherwise((Object)value.getDelegate()), HttpClientResponse.__TYPE_ARG);
        return ret;
    }

    @Override
    public Future<HttpClientResponse> otherwiseEmpty() {
        Future<HttpClientResponse> ret = Future.newInstance(this.delegate.otherwiseEmpty(), HttpClientResponse.__TYPE_ARG);
        return ret;
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.delegate.setFollowRedirects(followRedirects);
        return this;
    }

    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
        return this;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public String getRawMethod() {
        String ret = this.delegate.getRawMethod();
        return ret;
    }

    public HttpClientRequest setRawMethod(String method) {
        this.delegate.setRawMethod(method);
        return this;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public HttpClientRequest setHost(String host) {
        this.delegate.setHost(host);
        return this;
    }

    public String getHost() {
        String ret = this.delegate.getHost();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpClientRequest putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    @Override
    public void write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, handler);
    }

    @Override
    public void write(String chunk) {
        this.write(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWrite(String chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(chunk, (Handler<AsyncResult<Void>>)handler));
    }

    public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, enc, handler);
    }

    public void write(String chunk, String enc) {
        this.write(chunk, enc, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxWrite(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(chunk, enc, (Handler<AsyncResult<Void>>)handler));
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest sendHead() {
        this.delegate.sendHead();
        return this;
    }

    public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
        this.delegate.sendHead(completionHandler);
        return this;
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, handler);
    }

    @Override
    public void end(String chunk) {
        this.end(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxEnd(String chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(chunk, (Handler<AsyncResult<Void>>)handler));
    }

    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, enc, handler);
    }

    public void end(String chunk, String enc) {
        this.end(chunk, enc, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxEnd(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(chunk, enc, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk.getDelegate(), handler);
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer chunk) {
        this.end(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(chunk, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.end((Handler<AsyncResult<Void>>)handler));
    }

    public HttpClientRequest setTimeout(long timeoutMs) {
        this.delegate.setTimeout(timeoutMs);
        return this;
    }

    public HttpClientRequest pushHandler(final Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler((Handler)new Handler<io.vertx.core.http.HttpClientRequest>(){

            public void handle(io.vertx.core.http.HttpClientRequest event) {
                handler.handle((Object)HttpClientRequest.newInstance(event));
            }
        });
        return this;
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public HttpClientRequest connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest writeCustomFrame(int type, int flags, io.vertx.reactivex.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public StreamPriority getStreamPriority() {
        StreamPriority ret = this.delegate.getStreamPriority();
        return ret;
    }

    public HttpClientRequest setHandler(final Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.setHandler((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClientRequest setHandler() {
        return this.setHandler(ar -> {});
    }

    @Override
    public Single<HttpClientResponse> rxSetHandler() {
        return AsyncResultSingle.toSingle(handler -> this.setHandler((Handler)handler));
    }

    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

