/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.impl;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncResultMaybe<T>
extends Maybe<T> {
    private final Handler<Handler<AsyncResult<T>>> method;

    public AsyncResultMaybe(Handler<Handler<AsyncResult<T>>> method) {
        this.method = method;
    }

    protected void subscribeActual(MaybeObserver<? super T> observer) {
        block5: {
            final AtomicBoolean disposed = new AtomicBoolean();
            observer.onSubscribe(new Disposable(){

                public void dispose() {
                    disposed.set(true);
                }

                public boolean isDisposed() {
                    return disposed.get();
                }
            });
            if (!disposed.get()) {
                try {
                    this.method.handle(ar -> {
                        block9: {
                            if (!disposed.getAndSet(true)) {
                                if (ar.succeeded()) {
                                    try {
                                        Object val = ar.result();
                                        if (val != null) {
                                            observer.onSuccess(val);
                                            break block9;
                                        }
                                        observer.onComplete();
                                    }
                                    catch (Throwable throwable) {}
                                } else if (ar.failed()) {
                                    try {
                                        observer.onError(ar.cause());
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (disposed.getAndSet(true)) break block5;
                    try {
                        observer.onError((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

