/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex;

import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeTransformer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.reactivex.core.json.MaybeUnmarshaller;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class MaybeHelper {
    public static <T> MaybeObserver<T> toObserver(final Handler<AsyncResult<T>> handler) {
        final AtomicBoolean completed = new AtomicBoolean();
        return new MaybeObserver<T>(){

            public void onSubscribe(@NonNull Disposable d) {
            }

            public void onComplete() {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture());
                }
            }

            public void onSuccess(@NonNull T item) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture(item));
                }
            }

            public void onError(Throwable error) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.failedFuture((Throwable)error));
                }
            }
        };
    }

    public static <T> MaybeTransformer<Buffer, T> unmarshaller(Class<T> mappedType) {
        return new MaybeUnmarshaller(Function.identity(), mappedType);
    }

    public static <T> MaybeTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef) {
        return new MaybeUnmarshaller(Function.identity(), mappedTypeRef);
    }
}

