/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.mongo;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.GridFsDownloadOptions;
import io.vertx.ext.mongo.GridFsUploadOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ReadStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.List;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.mongo.MongoGridFsClient.class)
public class MongoGridFsClient {
    public static final TypeArg<MongoGridFsClient> __TYPE_ARG = new TypeArg(obj -> new MongoGridFsClient((io.vertx.ext.mongo.MongoGridFsClient)obj), MongoGridFsClient::getDelegate);
    private final io.vertx.ext.mongo.MongoGridFsClient delegate;
    private static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<Buffer> TYPE_ARG_1 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<Buffer> TYPE_ARG_2 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoGridFsClient that = (MongoGridFsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoGridFsClient(io.vertx.ext.mongo.MongoGridFsClient delegate) {
        this.delegate = delegate;
    }

    public MongoGridFsClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoGridFsClient)delegate;
    }

    public io.vertx.ext.mongo.MongoGridFsClient getDelegate() {
        return this.delegate;
    }

    public MongoGridFsClient delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.delete(id, resultHandler);
        return this;
    }

    public MongoGridFsClient delete(String id) {
        return this.delete(id, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxDelete(String id) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.delete(id, (Handler<AsyncResult<Void>>)fut)));
    }

    public ReadStream<Buffer> readByFileName(String fileName) {
        ReadStream<Buffer> ret = ReadStream.newInstance(this.delegate.readByFileName(fileName), TYPE_ARG_0);
        return ret;
    }

    public ReadStream<Buffer> readByFileNameWithOptions(String fileName, GridFsDownloadOptions options) {
        ReadStream<Buffer> ret = ReadStream.newInstance(this.delegate.readByFileNameWithOptions(fileName, options), TYPE_ARG_1);
        return ret;
    }

    public ReadStream<Buffer> readById(String id) {
        ReadStream<Buffer> ret = ReadStream.newInstance(this.delegate.readById(id), TYPE_ARG_2);
        return ret;
    }

    public MongoGridFsClient downloadByFileName(WriteStream<Buffer> stream, String fileName, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadByFileName(stream.getDelegate(), fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadByFileName(WriteStream<Buffer> stream, String fileName) {
        return this.downloadByFileName(stream, fileName, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadByFileName(WriteStream<Buffer> stream, String fileName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.downloadByFileName(stream, fileName, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoGridFsClient downloadByFileNameWithOptions(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadByFileNameWithOptions(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        return this.downloadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadByFileNameWithOptions(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.downloadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoGridFsClient downloadById(WriteStream<Buffer> stream, String id, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadById(stream.getDelegate(), id, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadById(WriteStream<Buffer> stream, String id) {
        return this.downloadById(stream, id, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadById(WriteStream<Buffer> stream, String id) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.downloadById(stream, id, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoGridFsClient downloadFile(String fileName, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadFile(fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadFile(String fileName) {
        return this.downloadFile(fileName, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadFile(String fileName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.downloadFile(fileName, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoGridFsClient downloadFileAs(String fileName, String newFileName, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadFileAs(fileName, newFileName, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadFileAs(String fileName, String newFileName) {
        return this.downloadFileAs(fileName, newFileName, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadFileAs(String fileName, String newFileName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.downloadFileAs(fileName, newFileName, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoGridFsClient downloadFileByID(String id, String fileName, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.downloadFileByID(id, fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient downloadFileByID(String id, String fileName) {
        return this.downloadFileByID(id, fileName, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxDownloadFileByID(String id, String fileName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.downloadFileByID(id, fileName, (Handler<AsyncResult<Long>>)fut)));
    }

    public MongoGridFsClient drop(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.drop(resultHandler);
        return this;
    }

    public MongoGridFsClient drop() {
        return this.drop((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxDrop() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.drop((Handler<AsyncResult<Void>>)fut)));
    }

    public MongoGridFsClient findAllIds(Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.findAllIds(resultHandler);
        return this;
    }

    public MongoGridFsClient findAllIds() {
        return this.findAllIds((Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxFindAllIds() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findAllIds((Handler<AsyncResult<List<String>>>)fut)));
    }

    public MongoGridFsClient findIds(JsonObject query, Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.findIds(query, resultHandler);
        return this;
    }

    public MongoGridFsClient findIds(JsonObject query) {
        return this.findIds(query, (Handler<AsyncResult<List<String>>>)((Handler)ar -> {}));
    }

    public Single<List<String>> rxFindIds(JsonObject query) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.findIds(query, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public MongoGridFsClient uploadByFileName(ReadStream<Buffer> stream, String fileName, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadByFileName(stream.getDelegate(), fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadByFileName(ReadStream<Buffer> stream, String fileName) {
        return this.uploadByFileName(stream, fileName, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadByFileName(ReadStream<Buffer> stream, String fileName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.uploadByFileName(stream, fileName, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoGridFsClient uploadByFileName(Observable<Buffer> stream, String fileName, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadByFileName(ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume(), fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadByFileName(Observable<Buffer> stream, String fileName) {
        return this.uploadByFileName(stream, fileName, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadByFileName(Observable<Buffer> stream, String fileName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.uploadByFileName(stream, fileName, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoGridFsClient uploadByFileNameWithOptions(ReadStream<Buffer> stream, String fileName, GridFsUploadOptions options, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadByFileNameWithOptions(ReadStream<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return this.uploadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadByFileNameWithOptions(ReadStream<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.uploadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoGridFsClient uploadByFileNameWithOptions(Observable<Buffer> stream, String fileName, GridFsUploadOptions options, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadByFileNameWithOptions(ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume(), fileName, options, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadByFileNameWithOptions(Observable<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return this.uploadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadByFileNameWithOptions(Observable<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.uploadByFileNameWithOptions(stream, fileName, options, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoGridFsClient uploadFile(String fileName, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadFile(fileName, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadFile(String fileName) {
        return this.uploadFile(fileName, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadFile(String fileName) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.uploadFile(fileName, (Handler<AsyncResult<String>>)fut)));
    }

    public MongoGridFsClient uploadFileWithOptions(String fileName, GridFsUploadOptions options, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.uploadFileWithOptions(fileName, options, resultHandler);
        return this;
    }

    public MongoGridFsClient uploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        return this.uploadFileWithOptions(fileName, options, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxUploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.uploadFileWithOptions(fileName, options, (Handler<AsyncResult<String>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public static MongoGridFsClient newInstance(io.vertx.ext.mongo.MongoGridFsClient arg) {
        return arg != null ? new MongoGridFsClient(arg) : null;
    }
}

