/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.datagram;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.datagram.DatagramPacket;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket
implements ReadStream<DatagramPacket>,
Measured {
    public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg(obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket)obj), DatagramSocket::getDelegate);
    private final io.vertx.core.datagram.DatagramSocket delegate;
    private Observable<DatagramPacket> observable;
    private static final TypeArg<DatagramPacket> TYPE_ARG_0 = new TypeArg(o1 -> DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatagramSocket that = (DatagramSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
        this.delegate = delegate;
    }

    public DatagramSocket(Object delegate) {
        this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
    }

    public io.vertx.core.datagram.DatagramSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<DatagramPacket> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.datagram.DatagramPacket, DatagramPacket> conv = DatagramPacket::newInstance;
            this.observable = RxHelper.toObservable((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @Override
    public Pipe<DatagramPacket> pipe() {
        Pipe<DatagramPacket> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<DatagramPacket> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<DatagramPacket> dst) {
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxPipeTo(WriteStream<DatagramPacket> dst) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    public DatagramSocket send(io.vertx.rxjava.core.buffer.Buffer packet, int port, String host, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(packet.getDelegate(), port, host, handler);
        return this;
    }

    public DatagramSocket send(io.vertx.rxjava.core.buffer.Buffer packet, int port, String host) {
        return this.send(packet, port, host, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSend(io.vertx.rxjava.core.buffer.Buffer packet, int port, String host) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(packet, port, host, (Handler<AsyncResult<Void>>)fut)));
    }

    public WriteStream<io.vertx.rxjava.core.buffer.Buffer> sender(int port, String host) {
        WriteStream<io.vertx.rxjava.core.buffer.Buffer> ret = WriteStream.newInstance(this.delegate.sender(port, host), TYPE_ARG_1);
        return ret;
    }

    public DatagramSocket send(String str, int port, String host, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(str, port, host, handler);
        return this;
    }

    public DatagramSocket send(String str, int port, String host) {
        return this.send(str, port, host, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSend(String str, int port, String host) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(str, port, host, (Handler<AsyncResult<Void>>)fut)));
    }

    public DatagramSocket send(String str, String enc, int port, String host, Handler<AsyncResult<Void>> handler) {
        this.delegate.send(str, enc, port, host, handler);
        return this;
    }

    public DatagramSocket send(String str, String enc, int port, String host) {
        return this.send(str, enc, port, host, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSend(String str, String enc, int port, String host) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(str, enc, port, host, (Handler<AsyncResult<Void>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public DatagramSocket listenMulticastGroup(String multicastAddress, Handler<AsyncResult<Void>> handler) {
        this.delegate.listenMulticastGroup(multicastAddress, handler);
        return this;
    }

    public DatagramSocket listenMulticastGroup(String multicastAddress) {
        return this.listenMulticastGroup(multicastAddress, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxListenMulticastGroup(String multicastAddress) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.listenMulticastGroup(multicastAddress, (Handler<AsyncResult<Void>>)fut)));
    }

    public DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<Void>> handler) {
        this.delegate.listenMulticastGroup(multicastAddress, networkInterface, source, handler);
        return this;
    }

    public DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return this.listenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxListenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.listenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<Void>>)fut)));
    }

    public DatagramSocket unlistenMulticastGroup(String multicastAddress, Handler<AsyncResult<Void>> handler) {
        this.delegate.unlistenMulticastGroup(multicastAddress, handler);
        return this;
    }

    public DatagramSocket unlistenMulticastGroup(String multicastAddress) {
        return this.unlistenMulticastGroup(multicastAddress, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxUnlistenMulticastGroup(String multicastAddress) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.unlistenMulticastGroup(multicastAddress, (Handler<AsyncResult<Void>>)fut)));
    }

    public DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<Void>> handler) {
        this.delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, handler);
        return this;
    }

    public DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return this.unlistenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxUnlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.unlistenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<Void>>)fut)));
    }

    public DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock, Handler<AsyncResult<Void>> handler) {
        this.delegate.blockMulticastGroup(multicastAddress, sourceToBlock, handler);
        return this;
    }

    public DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock) {
        return this.blockMulticastGroup(multicastAddress, sourceToBlock, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBlockMulticastGroup(String multicastAddress, String sourceToBlock) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.blockMulticastGroup(multicastAddress, sourceToBlock, (Handler<AsyncResult<Void>>)fut)));
    }

    public DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, Handler<AsyncResult<Void>> handler) {
        this.delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler);
        return this;
    }

    public DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        return this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBlockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, (Handler<AsyncResult<Void>>)fut)));
    }

    public DatagramSocket listen(int port, String host, Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listen(port, host, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> DatagramSocket.newInstance(event))));
        return this;
    }

    public DatagramSocket listen(int port, String host) {
        return this.listen(port, host, (Handler<AsyncResult<DatagramSocket>>)((Handler)ar -> {}));
    }

    public Single<DatagramSocket> rxListen(int port, String host) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.listen(port, host, (Handler<AsyncResult<DatagramSocket>>)fut)));
    }

    @Deprecated
    public DatagramSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Deprecated
    public DatagramSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Deprecated
    public DatagramSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Deprecated
    public DatagramSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public DatagramSocket handler(Handler<DatagramPacket> handler) {
        this.delegate.handler((Handler)new DelegatingHandler(handler, event -> DatagramPacket.newInstance(event)));
        return this;
    }

    @Override
    public DatagramSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
        return arg != null ? new DatagramSocket(arg) : null;
    }
}

