/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

public final class RESPEncoder {
    private static final byte[] NEG_ONE = RESPEncoder.convert(-1L);
    private static final int NUM_MAP_LENGTH = 256;
    private static final byte[][] NUM_MAP = new byte[256][];

    private static byte[] convert(long value) {
        boolean negative = value < 0L;
        long abs = Math.abs(value);
        int index = (value == 0L ? 0 : (int)Math.log10(abs)) + (negative ? 2 : 1);
        byte[] bytes = new byte[index];
        if (negative) {
            bytes[0] = 45;
        }
        long next = abs;
        while ((next /= 10L) > 0L) {
            bytes[--index] = (byte)(48L + abs % 10L);
            abs = next;
        }
        bytes[--index] = (byte)(48L + abs);
        return bytes;
    }

    public static byte[] numToBytes(long value) {
        if (value >= 0L && value < 256L) {
            int index = (int)value;
            return NUM_MAP[index];
        }
        if (value == -1L) {
            return NEG_ONE;
        }
        return RESPEncoder.convert(value);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            RESPEncoder.NUM_MAP[i] = RESPEncoder.convert(i);
        }
    }
}

