/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.impl.RedisConnectionInternal;
import io.vertx.redis.client.impl.RedisURI;
import java.util.function.Function;

class CommandReporter {
    private static final TagExtractor<CommandReporter> REQUEST_TAG_EXTRACTOR = new TagExtractor<CommandReporter>(){
        private final Tags[] TAGS = Tags.values();

        public int len(CommandReporter obj) {
            return this.TAGS.length;
        }

        public String name(CommandReporter obj, int index) {
            return this.TAGS[index].name;
        }

        public String value(CommandReporter obj, int index) {
            return this.TAGS[index].valueFunction.apply(obj);
        }
    };
    private final VertxTracer tracer;
    private final ClientMetrics metrics;
    private final Context context;
    private final TracingPolicy tracingPolicy;
    private final String command;
    private final String address;
    private final String user;
    private final String database;
    private final String networkPeerAddress;
    private final String networkPeerPort;
    private final String serverAddress;
    private final String serverPort;
    private Object trace;
    private Object metric;

    CommandReporter(RedisConnectionInternal conn, String command) {
        VertxInternal vertx = conn.vertx();
        RedisURI uri = conn.uri();
        this.tracer = vertx.tracer();
        this.metrics = conn.metrics();
        this.context = vertx.getContext();
        this.tracingPolicy = conn.tracingPolicy();
        this.command = command;
        this.address = uri.socketAddress().toString();
        this.networkPeerAddress = conn.remoteAddress().hostAddress();
        this.networkPeerPort = String.valueOf(conn.remoteAddress().port());
        this.serverAddress = uri.socketAddress().host();
        this.serverPort = String.valueOf(uri.socketAddress().port());
        this.user = uri.user();
        this.database = conn.isTainted() ? null : (uri.select() == null ? "0" : String.valueOf(uri.select()));
    }

    public void before() {
        if (this.tracer != null) {
            this.trace = this.tracer.sendRequest(this.context, SpanKind.RPC, this.tracingPolicy, (Object)this, "Command", (k, v) -> {}, REQUEST_TAG_EXTRACTOR);
        }
        if (this.metrics != null) {
            this.metric = this.metrics.requestBegin(this.command, (Object)this.command);
            this.metrics.requestEnd(this.metric);
        }
    }

    public void after(AsyncResult<?> ar) {
        if (this.tracer != null) {
            this.tracer.receiveResponse(this.context, ar.succeeded() ? ar.result() : null, this.trace, ar.failed() ? ar.cause() : null, TagExtractor.empty());
        }
        if (this.metrics != null) {
            if (ar.succeeded()) {
                this.metrics.responseBegin(this.metric, null);
                this.metrics.responseEnd(this.metric);
            } else {
                this.metrics.requestReset(this.metric);
            }
        }
    }

    static enum Tags {
        NETWORK_PEER_ADDRESS("network.peer.address", reporter -> reporter.networkPeerAddress),
        NETWORK_PEER_PORT("network.peer.port", reporter -> reporter.networkPeerPort),
        PEER_ADDRESS("peer.address", reporter -> reporter.address),
        SERVER_ADDRESS("server.address", reporter -> reporter.serverAddress),
        SERVER_PORT("server.port", reporter -> reporter.serverPort),
        SPAN_KIND("span.kind", reporter -> "client"),
        DB_USER("db.user", reporter -> reporter.user),
        DB_NAMESPACE("db.namespace", reporter -> reporter.database),
        DB_OPERATION_NAME("db.operation.name", reporter -> reporter.command),
        DB_SYSTEM("db.system", reporter -> "redis");

        final String name;
        final Function<CommandReporter, String> valueFunction;

        private Tags(String name, Function<CommandReporter, String> valueFunction) {
            this.name = name;
            this.valueFunction = valueFunction;
        }
    }
}

