/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.CommandImpl;
import io.vertx.redis.client.impl.RedisConnectionManager;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public abstract class BaseRedisClient<OPTS extends RedisConnectOptions>
implements Redis {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRedisClient.class);
    protected final VertxInternal vertx;
    protected final Supplier<Future<OPTS>> connectOptions;
    protected final RedisConnectionManager connectionManager;

    public BaseRedisClient(Vertx vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, Supplier<Future<OPTS>> connectOptions, TracingPolicy tracingPolicy) {
        this.vertx = (VertxInternal)vertx;
        this.connectOptions = connectOptions;
        this.connectionManager = new RedisConnectionManager(this.vertx, tcpOptions, poolOptions, connectOptions, tracingPolicy);
        this.connectionManager.start();
    }

    public RedisConnectionManager connectionManager() {
        return this.connectionManager;
    }

    @Override
    public Future<Void> close() {
        return this.connectionManager.close();
    }

    @Override
    public Future<@Nullable Response> send(Request request) {
        CommandImpl cmd = (CommandImpl)request.command();
        if (cmd.isPubSub()) {
            return this.vertx.getOrCreateContext().failedFuture("PubSub command in connection-less mode not allowed");
        }
        if (cmd.isTransactional()) {
            return this.vertx.getOrCreateContext().failedFuture("Transactional command in connection-less mode not allowed");
        }
        return this.connect().compose(conn -> conn.send(request).eventually(() -> conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0))));
    }

    @Override
    public Future<List<@Nullable Response>> batch(List<Request> requests) {
        if (requests.isEmpty()) {
            LOG.debug((Object)"Empty batch");
            return this.vertx.getOrCreateContext().succeededFuture(Collections.emptyList());
        }
        for (Request req : requests) {
            CommandImpl cmd = (CommandImpl)req.command();
            if (!cmd.isPubSub()) continue;
            return Future.failedFuture((String)"PubSub command in connection-less batch not allowed");
        }
        return this.connect().compose(conn -> conn.batch(requests).eventually(() -> conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0))));
    }
}

