/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.ProtocolVersion;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisClusterTransactions;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisTopology;
import java.util.ArrayList;
import java.util.Map;

public class RedisOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType(RedisClientType.valueOf((String)member.getValue()));
                    break;
                }
                case "netClientOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setNetClientOptions(new NetClientOptions((JsonObject)member.getValue()));
                    break;
                }
                case "topology": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTopology(RedisTopology.valueOf((String)member.getValue()));
                    break;
                }
                case "endpoints": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setEndpoints(list);
                    break;
                }
                case "maxWaitingHandlers": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWaitingHandlers(((Number)member.getValue()).intValue());
                    break;
                }
                case "masterName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMasterName((String)member.getValue());
                    break;
                }
                case "role": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRole(RedisRole.valueOf((String)member.getValue()));
                    break;
                }
                case "useReplicas": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUseReplicas(RedisReplicas.valueOf((String)member.getValue()));
                    break;
                }
                case "clusterTransactions": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClusterTransactions(RedisClusterTransactions.valueOf((String)member.getValue()));
                    break;
                }
                case "maxNestedArrays": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxNestedArrays(((Number)member.getValue()).intValue());
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTracingPolicy(TracingPolicy.valueOf((String)((String)member.getValue())));
                    break;
                }
                case "poolCleanerInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPoolCleanerInterval(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxPoolWaiting": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxPoolWaiting(((Number)member.getValue()).intValue());
                    break;
                }
                case "poolRecycleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPoolRecycleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "user": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUser((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "protocolNegotiation": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setProtocolNegotiation((Boolean)member.getValue());
                    break;
                }
                case "preferredProtocolVersion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPreferredProtocolVersion(ProtocolVersion.valueOf((String)member.getValue()));
                    break;
                }
                case "poolName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPoolName((String)member.getValue());
                    break;
                }
                case "metricsName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMetricsName((String)member.getValue());
                    break;
                }
                case "hashSlotCacheTTL": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHashSlotCacheTTL(((Number)member.getValue()).longValue());
                    break;
                }
                case "autoFailover": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAutoFailover((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(RedisOptions obj, JsonObject json) {
        RedisOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(RedisOptions obj, Map<String, Object> json) {
        if (obj.getType() != null) {
            json.put("type", obj.getType().name());
        }
        if (obj.getNetClientOptions() != null) {
            json.put("netClientOptions", obj.getNetClientOptions().toJson());
        }
        if (obj.getTopology() != null) {
            json.put("topology", obj.getTopology().name());
        }
        if (obj.getEndpoints() != null) {
            JsonArray array = new JsonArray();
            obj.getEndpoints().forEach(item -> array.add(item));
            json.put("endpoints", array);
        }
        json.put("maxWaitingHandlers", obj.getMaxWaitingHandlers());
        if (obj.getMasterName() != null) {
            json.put("masterName", obj.getMasterName());
        }
        if (obj.getRole() != null) {
            json.put("role", obj.getRole().name());
        }
        if (obj.getUseReplicas() != null) {
            json.put("useReplicas", obj.getUseReplicas().name());
        }
        if (obj.getClusterTransactions() != null) {
            json.put("clusterTransactions", obj.getClusterTransactions().name());
        }
        json.put("maxNestedArrays", obj.getMaxNestedArrays());
        if (obj.getTracingPolicy() != null) {
            json.put("tracingPolicy", obj.getTracingPolicy().name());
        }
        json.put("poolCleanerInterval", obj.getPoolCleanerInterval());
        json.put("maxPoolSize", obj.getMaxPoolSize());
        json.put("maxPoolWaiting", obj.getMaxPoolWaiting());
        json.put("poolRecycleTimeout", obj.getPoolRecycleTimeout());
        if (obj.getUser() != null) {
            json.put("user", obj.getUser());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        json.put("protocolNegotiation", obj.isProtocolNegotiation());
        if (obj.getPreferredProtocolVersion() != null) {
            json.put("preferredProtocolVersion", obj.getPreferredProtocolVersion().name());
        }
        if (obj.getPoolName() != null) {
            json.put("poolName", obj.getPoolName());
        }
        if (obj.getMetricsName() != null) {
            json.put("metricsName", obj.getMetricsName());
        }
        json.put("hashSlotCacheTTL", obj.getHashSlotCacheTTL());
        json.put("autoFailover", obj.isAutoFailover());
    }
}

