/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisConnectException;
import io.vertx.redis.client.impl.RedisConnectionManager;
import io.vertx.redis.client.impl.Slots;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

class SharedSlots {
    private static final Logger LOG = LoggerFactory.getLogger(SharedSlots.class);
    private final Vertx vertx;
    private final RedisClusterConnectOptions connectOptions;
    private final RedisConnectionManager connectionManager;
    private final AtomicReference<Future<Slots>> slots = new AtomicReference();

    SharedSlots(Vertx vertx, RedisClusterConnectOptions connectOptions, RedisConnectionManager connectionManager) {
        this.vertx = vertx;
        this.connectOptions = connectOptions;
        this.connectionManager = connectionManager;
    }

    Future<Slots> get() {
        Promise promise;
        Future future;
        do {
            Future<Slots> slots;
            if ((slots = this.slots.get()) == null) continue;
            return slots;
        } while (!this.slots.compareAndSet(null, (Future<Slots>)(future = (promise = Promise.promise()).future())));
        LOG.debug((Object)"Obtaining hash slot assignment");
        this.getSlots(this.connectOptions.getEndpoints(), 0, ConcurrentHashMap.newKeySet(), (Handler<AsyncResult<Slots>>)promise);
        return future;
    }

    private void getSlots(List<String> endpoints, int index, Set<Throwable> failures, Handler<AsyncResult<Slots>> onGotSlots) {
        if (index >= endpoints.size()) {
            StringBuilder message = new StringBuilder("Cannot connect to any of the provided endpoints");
            for (Throwable failure : failures) {
                message.append("\n- ").append(failure);
            }
            onGotSlots.handle((Object)Future.failedFuture((Throwable)new RedisConnectException(message.toString())));
            this.scheduleInvalidation();
            return;
        }
        this.connectionManager.getConnection(endpoints.get(index), RedisReplicas.NEVER != this.connectOptions.getUseReplicas() ? Request.cmd(Command.READONLY) : null).onFailure(err -> {
            failures.add((Throwable)err);
            this.getSlots(endpoints, index + 1, failures, onGotSlots);
        }).onSuccess(conn -> this.getSlots((String)endpoints.get(index), (RedisConnection)conn).onComplete(result -> {
            conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
            if (result.failed()) {
                failures.add(result.cause());
                this.getSlots(endpoints, index + 1, failures, onGotSlots);
            } else {
                Slots slots = (Slots)result.result();
                onGotSlots.handle((Object)Future.succeededFuture((Object)slots));
                this.scheduleInvalidation();
            }
        }));
    }

    private Future<Slots> getSlots(String endpoint, RedisConnection conn) {
        return conn.send(Request.cmd(Command.CLUSTER).arg("SLOTS")).compose(reply -> {
            Slots result;
            if (reply == null || reply.size() == 0) {
                return Future.failedFuture((String)"CLUSTER SLOTS No slots available in the cluster.");
            }
            try {
                result = new Slots(endpoint, (Response)reply);
            }
            catch (Exception e) {
                return Future.failedFuture((String)("CLUSTER SLOTS response invalid: " + e));
            }
            return Future.succeededFuture((Object)result);
        });
    }

    void invalidate() {
        this.slots.set(null);
    }

    void scheduleInvalidation() {
        this.vertx.setTimer(this.connectOptions.getHashSlotCacheTTL(), ignored -> this.invalidate());
    }
}

