/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgNotice;
import io.vertx.pgclient.PgNotification;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.sqlclient.SqlConnection;

@VertxGen
public interface PgConnection
extends SqlConnection {
    public static Future<PgConnection> connect(Vertx vertx, PgConnectOptions options) {
        return PgConnectionImpl.connect((ContextInternal)vertx.getOrCreateContext(), options);
    }

    public static Future<PgConnection> connect(Vertx vertx) {
        return PgConnection.connect(vertx, PgConnectOptions.fromEnv());
    }

    public static Future<PgConnection> connect(Vertx vertx, String connectionUri) {
        return PgConnection.connect(vertx, PgConnectOptions.fromUri(connectionUri));
    }

    @Fluent
    public PgConnection notificationHandler(Handler<PgNotification> var1);

    @Fluent
    public PgConnection noticeHandler(Handler<PgNotice> var1);

    public Future<Void> cancelRequest();

    public int processId();

    public int secretKey();

    @Fluent
    public PgConnection exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public PgConnection closeHandler(Handler<Void> var1);

    public static PgConnection cast(SqlConnection sqlConnection) {
        return (PgConnection)sqlConnection;
    }
}

