/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLCodec;

class MySQLDecoder
extends ChannelInboundHandlerAdapter {
    private final MySQLCodec codec;
    private ByteBuf payload;
    private short sequenceId;

    MySQLDecoder(MySQLCodec codec) {
        this.codec = codec;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf packet = (ByteBuf)msg;
        int payloadLength = packet.readUnsignedMediumLE();
        this.sequenceId = packet.readUnsignedByte();
        if (this.payload != null) {
            CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.payload;
            compositeByteBuf.addComponent(true, packet);
        } else {
            this.payload = payloadLength >= 0xFFFFFF ? ctx.alloc().compositeDirectBuffer().addComponent(true, packet) : packet;
        }
        if (payloadLength < 0xFFFFFF) {
            this.decodePackets();
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.releaseMessage();
    }

    private void releaseMessage() {
        if (this.payload != null) {
            this.payload.release();
            this.payload = null;
        }
    }

    private void decodePackets() {
        try {
            this.codec.checkFireAndForgetCommands();
            CommandCodec<?, ?> ctx = this.codec.peek();
            if (ctx == null) {
                throw new IllegalStateException("No command codec for packet");
            }
            ctx.sequenceId = this.sequenceId + 1;
            ctx.decodePayload(this.payload, this.payload.readableBytes());
            this.codec.checkFireAndForgetCommands();
        }
        finally {
            this.releaseMessage();
        }
    }
}

