/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.json.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySQLConnectionUriParser {
    private static final String SCHEME_DESIGNATOR_REGEX = "(mysql|mariadb)://";
    private static final String USER_INFO_REGEX = "((?<userinfo>[a-zA-Z0-9\\-._~%!*]+(:[a-zA-Z0-9\\-._~%!*]*)?)@)?";
    private static final String NET_LOCATION_REGEX = "(?<netloc>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)?";
    private static final String PORT_REGEX = "(:(?<port>\\d+))?";
    private static final String SCHEMA_REGEX = "(/(?<schema>[a-zA-Z0-9\\-._~%!*]+))?";
    private static final String ATTRIBUTES_REGEX = "(\\?(?<attributes>.*))?";
    private static final Pattern SCHEME_DESIGNATOR_PATTERN = Pattern.compile("^(mysql|mariadb)://");
    private static final Pattern FULL_URI_PATTERN = Pattern.compile("^(mysql|mariadb)://((?<userinfo>[a-zA-Z0-9\\-._~%!*]+(:[a-zA-Z0-9\\-._~%!*]*)?)@)?(?<netloc>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)?(:(?<port>\\d+))?(/(?<schema>[a-zA-Z0-9\\-._~%!*]+))?(\\?(?<attributes>.*))?$");

    public static JsonObject parse(String connectionUri) {
        return MySQLConnectionUriParser.parse(connectionUri, true);
    }

    public static JsonObject parse(String connectionUri, boolean exact) {
        try {
            Matcher matcher = SCHEME_DESIGNATOR_PATTERN.matcher(connectionUri);
            if (matcher.find() || exact) {
                JsonObject configuration = new JsonObject();
                MySQLConnectionUriParser.doParse(connectionUri, configuration);
                return configuration;
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse invalid connection URI: " + connectionUri, e);
        }
    }

    private static void doParse(String connectionUri, JsonObject configuration) {
        Matcher matcher = FULL_URI_PATTERN.matcher(connectionUri);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Wrong syntax of connection URI");
        }
        MySQLConnectionUriParser.parseUserAndPassword(matcher.group("userinfo"), configuration);
        MySQLConnectionUriParser.parseNetLocation(matcher.group("netloc"), configuration);
        MySQLConnectionUriParser.parsePort(matcher.group("port"), configuration);
        MySQLConnectionUriParser.parseSchemaName(matcher.group("schema"), configuration);
        MySQLConnectionUriParser.parseAttributes(matcher.group("attributes"), configuration);
    }

    private static void parseUserAndPassword(String userInfo, JsonObject configuration) {
        if (userInfo == null || userInfo.isEmpty()) {
            return;
        }
        if (MySQLConnectionUriParser.occurExactlyOnce(userInfo, ":")) {
            int index = userInfo.indexOf(":");
            String user = userInfo.substring(0, index);
            if (user.isEmpty()) {
                throw new IllegalArgumentException("Can not only specify the password without a concrete user");
            }
            String password = userInfo.substring(index + 1);
            configuration.put("user", (Object)MySQLConnectionUriParser.decodeUrl(user));
            configuration.put("password", (Object)MySQLConnectionUriParser.decodeUrl(password));
        } else if (!userInfo.contains(":")) {
            configuration.put("user", (Object)MySQLConnectionUriParser.decodeUrl(userInfo));
        } else {
            throw new IllegalArgumentException("Can not use multiple delimiters to delimit user and password");
        }
    }

    private static void parseNetLocation(String hostInfo, JsonObject configuration) {
        if (hostInfo == null || hostInfo.isEmpty()) {
            return;
        }
        MySQLConnectionUriParser.parseNetLocationValue(MySQLConnectionUriParser.decodeUrl(hostInfo), configuration);
    }

    private static void parsePort(String portInfo, JsonObject configuration) {
        int port;
        if (portInfo == null || portInfo.isEmpty()) {
            return;
        }
        try {
            port = Integer.parseInt(MySQLConnectionUriParser.decodeUrl(portInfo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The port must be a valid integer");
        }
        if (port > 65535 || port <= 0) {
            throw new IllegalArgumentException("The port can only range in 1-65535");
        }
        configuration.put("port", (Object)port);
    }

    private static void parseSchemaName(String schemaInfo, JsonObject configuration) {
        if (schemaInfo == null || schemaInfo.isEmpty()) {
            return;
        }
        configuration.put("database", (Object)MySQLConnectionUriParser.decodeUrl(schemaInfo));
    }

    private static void parseAttributes(String attributesInfo, JsonObject configuration) {
        if (attributesInfo == null || attributesInfo.isEmpty()) {
            return;
        }
        HashMap properties = new HashMap();
        block18: for (String parameterPair : attributesInfo.split("&")) {
            if (parameterPair.isEmpty()) continue;
            int indexOfDelimiter = parameterPair.indexOf("=");
            if (indexOfDelimiter < 0) {
                throw new IllegalArgumentException(String.format("Missing delimiter '=' of parameters \"%s\" in the part \"%s\"", attributesInfo, parameterPair));
            }
            String key = parameterPair.substring(0, indexOfDelimiter).toLowerCase();
            String value = MySQLConnectionUriParser.decodeUrl(parameterPair.substring(indexOfDelimiter + 1).trim());
            switch (key) {
                case "port": {
                    MySQLConnectionUriParser.parsePort(value, configuration);
                    continue block18;
                }
                case "host": {
                    MySQLConnectionUriParser.parseNetLocationValue(value, configuration);
                    continue block18;
                }
                case "socket": {
                    configuration.put("host", (Object)value);
                    continue block18;
                }
                case "user": {
                    configuration.put("user", (Object)value);
                    continue block18;
                }
                case "password": {
                    configuration.put("password", (Object)value);
                    continue block18;
                }
                case "schema": {
                    configuration.put("database", (Object)value);
                    continue block18;
                }
                case "useaffectedrows": {
                    configuration.put("useAffectedRows", (Object)Boolean.parseBoolean(value));
                    continue block18;
                }
                default: {
                    configuration.put(key, (Object)value);
                }
            }
        }
        if (!properties.isEmpty()) {
            configuration.put("properties", properties);
        }
    }

    private static void parseNetLocationValue(String hostValue, JsonObject configuration) {
        if (MySQLConnectionUriParser.isRegardedAsIpv6Address(hostValue)) {
            configuration.put("host", (Object)hostValue.substring(1, hostValue.length() - 1));
        } else {
            configuration.put("host", (Object)hostValue);
        }
    }

    private static boolean isRegardedAsIpv6Address(String hostAddress) {
        return hostAddress.startsWith("[") && hostAddress.endsWith("]");
    }

    private static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("The connection uri contains unknown characters that can not be resolved.");
        }
    }

    private static boolean occurExactlyOnce(String uri, String character) {
        return uri.contains(character) && uri.indexOf(character) == uri.lastIndexOf(character);
    }
}

