/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.mysqlclient.MySQLAuthenticationPlugin;
import io.vertx.mysqlclient.MySQLConnectOptionsConverter;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.MySQLConnectionUriParser;
import io.vertx.sqlclient.SqlConnectOptions;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

@DataObject
@JsonGen(publicConverter=false)
public class MySQLConnectOptions
extends SqlConnectOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 3306;
    public static final String DEFAULT_USER = "root";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_SCHEMA = "";
    public static final String DEFAULT_CHARSET = "utf8mb4";
    public static final boolean DEFAULT_USE_AFFECTED_ROWS = false;
    public static final Map<String, String> DEFAULT_CONNECTION_ATTRIBUTES;
    public static final SslMode DEFAULT_SSL_MODE;
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final int DEFAULT_PIPELINING_LIMIT = 1;
    private String collation;
    private String charset = "utf8mb4";
    private Boolean useAffectedRows = false;
    private SslMode sslMode = DEFAULT_SSL_MODE;
    private String serverRsaPublicKeyPath;
    private Buffer serverRsaPublicKeyValue;
    private String characterEncoding = "UTF-8";
    private int pipeliningLimit = 1;
    private MySQLAuthenticationPlugin authenticationPlugin = MySQLAuthenticationPlugin.DEFAULT;

    public static MySQLConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof MySQLConnectOptions) {
            return (MySQLConnectOptions)options;
        }
        return new MySQLConnectOptions(options);
    }

    public static MySQLConnectOptions fromUri(String connectionUri) throws IllegalArgumentException {
        JsonObject parsedConfiguration = MySQLConnectionUriParser.parse(connectionUri);
        return new MySQLConnectOptions(parsedConfiguration);
    }

    public MySQLConnectOptions() {
    }

    public MySQLConnectOptions(JsonObject json) {
        super(json);
        MySQLConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public MySQLConnectOptions(SqlConnectOptions other) {
        super(other);
        if (other instanceof MySQLConnectOptions) {
            MySQLConnectOptions opts = (MySQLConnectOptions)other;
            this.collation = opts.collation;
            this.charset = opts.charset;
            this.useAffectedRows = opts.useAffectedRows;
            this.sslMode = opts.sslMode;
            this.serverRsaPublicKeyPath = opts.serverRsaPublicKeyPath;
            this.serverRsaPublicKeyValue = opts.serverRsaPublicKeyValue != null ? opts.serverRsaPublicKeyValue.copy() : null;
            this.characterEncoding = opts.characterEncoding;
            this.pipeliningLimit = opts.pipeliningLimit;
            this.authenticationPlugin = opts.authenticationPlugin;
        }
    }

    public MySQLConnectOptions(MySQLConnectOptions other) {
        super((SqlConnectOptions)other);
        this.collation = other.collation;
        this.charset = other.charset;
        this.useAffectedRows = other.useAffectedRows;
        this.sslMode = other.sslMode;
        this.serverRsaPublicKeyPath = other.serverRsaPublicKeyPath;
        this.serverRsaPublicKeyValue = other.serverRsaPublicKeyValue != null ? other.serverRsaPublicKeyValue.copy() : null;
        this.characterEncoding = other.characterEncoding;
        this.pipeliningLimit = other.pipeliningLimit;
        this.authenticationPlugin = other.authenticationPlugin;
    }

    public String getCollation() {
        return this.collation;
    }

    public MySQLConnectOptions setCollation(String collation) {
        if (collation != null && !MySQLCollation.SUPPORTED_COLLATION_NAMES.contains(collation)) {
            throw new IllegalArgumentException("Unsupported collation: " + collation);
        }
        this.collation = collation;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public MySQLConnectOptions setCharset(String charset) {
        if (charset != null && !MySQLCollation.SUPPORTED_CHARSET_NAMES.contains(charset)) {
            throw new IllegalArgumentException("Unsupported charset: " + charset);
        }
        this.charset = charset;
        return this;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public MySQLConnectOptions setCharacterEncoding(String characterEncoding) {
        if (characterEncoding != null && !Charset.isSupported(characterEncoding)) {
            throw new IllegalArgumentException("Unsupported Java charset: " + characterEncoding);
        }
        this.characterEncoding = characterEncoding;
        return this;
    }

    public boolean isUseAffectedRows() {
        return this.useAffectedRows;
    }

    public MySQLConnectOptions setUseAffectedRows(boolean useAffectedRows) {
        this.useAffectedRows = useAffectedRows;
        return this;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public MySQLConnectOptions setSslMode(SslMode sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public MySQLAuthenticationPlugin getAuthenticationPlugin() {
        return this.authenticationPlugin;
    }

    public MySQLConnectOptions setAuthenticationPlugin(MySQLAuthenticationPlugin authenticationPlugin) {
        Objects.requireNonNull(authenticationPlugin, "Authentication plugin can not be null");
        this.authenticationPlugin = authenticationPlugin;
        return this;
    }

    public MySQLConnectOptions setServerRsaPublicKeyPath(String serverRsaPublicKeyPath) {
        this.serverRsaPublicKeyPath = serverRsaPublicKeyPath;
        return this;
    }

    public String getServerRsaPublicKeyPath() {
        return this.serverRsaPublicKeyPath;
    }

    public MySQLConnectOptions setServerRsaPublicKeyValue(Buffer serverRsaPublicKeyValue) {
        this.serverRsaPublicKeyValue = serverRsaPublicKeyValue;
        return this;
    }

    public Buffer getServerRsaPublicKeyValue() {
        return this.serverRsaPublicKeyValue;
    }

    public int getPipeliningLimit() {
        return this.pipeliningLimit;
    }

    public MySQLConnectOptions setPipeliningLimit(int pipeliningLimit) {
        if (pipeliningLimit < 1) {
            throw new IllegalArgumentException("pipelining limit can not be less than 1");
        }
        this.pipeliningLimit = pipeliningLimit;
        return this;
    }

    public MySQLConnectOptions setHost(String host) {
        return (MySQLConnectOptions)super.setHost(host);
    }

    public MySQLConnectOptions setPort(int port) {
        return (MySQLConnectOptions)super.setPort(port);
    }

    public MySQLConnectOptions setUser(String user) {
        return (MySQLConnectOptions)super.setUser(user);
    }

    public MySQLConnectOptions setPassword(String password) {
        return (MySQLConnectOptions)super.setPassword(password);
    }

    public MySQLConnectOptions setDatabase(String database) {
        return (MySQLConnectOptions)super.setDatabase(database);
    }

    public MySQLConnectOptions setCachePreparedStatements(boolean cachePreparedStatements) {
        return (MySQLConnectOptions)super.setCachePreparedStatements(cachePreparedStatements);
    }

    public MySQLConnectOptions setPreparedStatementCacheMaxSize(int preparedStatementCacheMaxSize) {
        return (MySQLConnectOptions)super.setPreparedStatementCacheMaxSize(preparedStatementCacheMaxSize);
    }

    @GenIgnore
    public MySQLConnectOptions setPreparedStatementCacheSqlFilter(Predicate<String> predicate) {
        return (MySQLConnectOptions)super.setPreparedStatementCacheSqlFilter(predicate);
    }

    public MySQLConnectOptions setPreparedStatementCacheSqlLimit(int preparedStatementCacheSqlLimit) {
        return (MySQLConnectOptions)super.setPreparedStatementCacheSqlLimit(preparedStatementCacheSqlLimit);
    }

    public MySQLConnectOptions setProperties(Map<String, String> properties) {
        return (MySQLConnectOptions)super.setProperties(properties);
    }

    @GenIgnore
    public MySQLConnectOptions addProperty(String key, String value) {
        return (MySQLConnectOptions)super.addProperty(key, value);
    }

    public MySQLConnectOptions setReconnectAttempts(int attempts) {
        return (MySQLConnectOptions)super.setReconnectAttempts(attempts);
    }

    public MySQLConnectOptions setReconnectInterval(long interval) {
        return (MySQLConnectOptions)super.setReconnectInterval(interval);
    }

    public MySQLConnectOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        return (MySQLConnectOptions)super.setTracingPolicy(tracingPolicy);
    }

    public MySQLConnectOptions setSslOptions(ClientSSLOptions sslOptions) {
        return (MySQLConnectOptions)super.setSslOptions(sslOptions);
    }

    protected void init() {
        super.init();
        this.setHost(DEFAULT_HOST);
        this.setPort(3306);
        this.setUser(DEFAULT_USER);
        this.setPassword("");
        this.setDatabase("");
        this.setMetricsName("");
        this.setProperties(new HashMap<String, String>(DEFAULT_CONNECTION_ATTRIBUTES));
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        MySQLConnectOptionsConverter.toJson(this, json);
        return json;
    }

    @GenIgnore
    public SocketAddress getSocketAddress() {
        return this.isUsingDomainSocket() ? SocketAddress.domainSocketAddress((String)this.getHost()) : super.getSocketAddress();
    }

    @GenIgnore
    public boolean isUsingDomainSocket() {
        return this.getHost().startsWith("/");
    }

    public MySQLConnectOptions merge(JsonObject other) {
        JsonObject json = this.toJson();
        json.mergeIn(other);
        return new MySQLConnectOptions(json);
    }

    static {
        DEFAULT_SSL_MODE = SslMode.DISABLED;
        HashMap<String, String> defaultAttributes = new HashMap<String, String>();
        defaultAttributes.put("_client_name", "vertx-mysql-client");
        DEFAULT_CONNECTION_ATTRIBUTES = Collections.unmodifiableMap(defaultAttributes);
    }
}

