/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mysqlclient.impl.MySQLPoolOptions;
import io.vertx.mysqlclient.spi.MySQLDriver;
import io.vertx.sqlclient.ClientBuilder;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.ClientBuilderBase;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Supplier;

@VertxGen
public interface MySQLBuilder {
    public static Pool pool(Handler<ClientBuilder<Pool>> block) {
        return ClientBuilder.pool((Driver)MySQLDriver.INSTANCE, block);
    }

    public static ClientBuilder<Pool> pool() {
        return ClientBuilder.pool((Driver)MySQLDriver.INSTANCE);
    }

    public static SqlClient client(Handler<ClientBuilder<SqlClient>> handler) {
        ClientBuilder<SqlClient> builder = MySQLBuilder.client();
        handler.handle(builder);
        return (SqlClient)builder.build();
    }

    public static ClientBuilder<SqlClient> client() {
        return new ClientBuilderBase<SqlClient>((Driver)MySQLDriver.INSTANCE){

            public ClientBuilder<SqlClient> with(PoolOptions options) {
                if (options != null) {
                    options = new MySQLPoolOptions(options).setPipelined(true);
                }
                return super.with(options);
            }

            protected SqlClient create(Vertx vertx, Supplier<Future<SqlConnectOptions>> databases, PoolOptions poolOptions) {
                return this.driver.createPool(vertx, databases, poolOptions);
            }
        };
    }
}

