/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.Measured;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.micrometer.MetricsService;
import io.vertx.micrometer.impl.MicrometerMetrics;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MetricsServiceImpl
implements MetricsService {
    private final MicrometerMetrics metrics;

    public MetricsServiceImpl(Measured measured) {
        MetricsProvider provider = (MetricsProvider)measured;
        Metrics baseMetrics = provider.getMetrics();
        this.metrics = baseMetrics instanceof MicrometerMetrics ? (MicrometerMetrics)baseMetrics : null;
    }

    @Override
    public String getBaseName() {
        return this.metrics != null ? this.metrics.baseName() : null;
    }

    @Override
    public JsonObject getMetricsSnapshot() {
        return this.metrics != null ? this.snapshot(this.metrics.registry(), this.metrics.baseName()) : null;
    }

    @Override
    public JsonObject getMetricsSnapshot(String baseName) {
        return this.metrics != null ? this.snapshot(this.metrics.registry(), baseName) : null;
    }

    @Override
    public Set<String> metricsNames() {
        if (this.metrics != null) {
            return this.metrics.registry().getMeters().stream().map(m -> m.getId().getName()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public MeterRegistry getRegistry() {
        return this.metrics != null ? this.metrics.registry() : null;
    }

    private JsonObject snapshot(MeterRegistry registry, String baseName) {
        Stream<Object> filtered = baseName == null ? registry.getMeters().stream() : registry.getMeters().stream().filter(m -> m.getId().getName().startsWith(baseName));
        LinkedHashMap map = filtered.sorted(Comparator.comparing(m -> m.getId().getName())).collect(Collectors.groupingBy(m -> m.getId().getName(), LinkedHashMap::new, Collectors.mapping(MetricsServiceImpl::metricToJson, Collectors.toList())));
        return new JsonObject((Map)map);
    }

    private static JsonObject metricToJson(Meter meter) {
        JsonObject tags = new JsonObject();
        meter.getId().getTags().forEach(tag -> tags.put(tag.getKey(), (Object)tag.getValue()));
        JsonObject obj = new JsonObject().put("tags", (Object)tags);
        return (JsonObject)meter.match(gauge -> MetricsServiceImpl.gaugeToJson(obj, gauge), counter -> MetricsServiceImpl.counterToJson(obj, counter), timer -> MetricsServiceImpl.timerToJson(obj, timer), summary -> MetricsServiceImpl.summaryToJson(obj, summary), longTaskTimer -> MetricsServiceImpl.longTaskTimerToJson(obj, longTaskTimer), timeGauge -> MetricsServiceImpl.timeGaugeToJson(obj, timeGauge), functionCounter -> MetricsServiceImpl.functionCounterToJson(obj, functionCounter), functionTimer -> MetricsServiceImpl.functionTimerToJson(obj, functionTimer), m -> obj.put("type", (Object)"unknown"));
    }

    private static JsonObject summaryToJson(JsonObject obj, DistributionSummary summary) {
        HistogramSnapshot snapshot = summary.takeSnapshot(false);
        return obj.put("type", (Object)"summary").put("count", (Object)snapshot.count()).put("total", (Object)snapshot.total()).put("mean", (Object)snapshot.mean()).put("max", (Object)snapshot.max());
    }

    private static JsonObject timerToJson(JsonObject obj, Timer timer) {
        return obj.put("type", (Object)"timer").put("count", (Object)timer.count()).put("totalTimeMs", (Object)timer.totalTime(TimeUnit.MILLISECONDS)).put("meanMs", (Object)timer.mean(TimeUnit.MILLISECONDS)).put("maxMs", (Object)timer.max(TimeUnit.MILLISECONDS));
    }

    private static JsonObject gaugeToJson(JsonObject obj, Gauge gauge) {
        return obj.put("type", (Object)"gauge").put("value", (Object)gauge.value());
    }

    private static JsonObject counterToJson(JsonObject obj, Counter counter) {
        return obj.put("type", (Object)"counter").put("count", (Object)counter.count());
    }

    private static JsonObject longTaskTimerToJson(JsonObject obj, LongTaskTimer longTaskTimer) {
        return obj.put("type", (Object)"longTaskTimer").put("activeTasks", (Object)longTaskTimer.activeTasks()).put("durationMs", (Object)longTaskTimer.duration(TimeUnit.MILLISECONDS));
    }

    private static JsonObject timeGaugeToJson(JsonObject obj, TimeGauge timeGauge) {
        return obj.put("type", (Object)"timeGauge").put("valueMs", (Object)timeGauge.value(TimeUnit.MILLISECONDS));
    }

    private static JsonObject functionCounterToJson(JsonObject obj, FunctionCounter functionCounter) {
        return obj.put("type", (Object)"functionCounter").put("count", (Object)functionCounter.count());
    }

    private static JsonObject functionTimerToJson(JsonObject obj, FunctionTimer functionTimer) {
        return obj.put("type", (Object)"functionTimer").put("count", (Object)functionTimer.count()).put("totalTimeMs", (Object)functionTimer.totalTime(TimeUnit.MILLISECONDS)).put("meanMs", (Object)functionTimer.mean(TimeUnit.MILLISECONDS));
    }
}

