/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.micrometer.VertxPrometheusOptionsConverter;
import java.util.Map;

@DataObject(generateConverter=true, inheritConverter=true)
public class VertxPrometheusOptions {
    public static final boolean DEFAULT_ENABLED = false;
    public static final boolean DEFAULT_START_EMBEDDED_SERVER = false;
    public static final String DEFAULT_EMBEDDED_SERVER_ENDPOINT = "/metrics";
    public static final boolean DEFAULT_PUBLISH_QUANTILES = false;
    private boolean enabled;
    private boolean startEmbeddedServer;
    private HttpServerOptions embeddedServerOptions;
    private String embeddedServerEndpoint;
    private boolean publishQuantiles;

    public VertxPrometheusOptions() {
        this.enabled = false;
        this.startEmbeddedServer = false;
        this.embeddedServerEndpoint = DEFAULT_EMBEDDED_SERVER_ENDPOINT;
        this.publishQuantiles = false;
    }

    public VertxPrometheusOptions(VertxPrometheusOptions other) {
        this.enabled = other.enabled;
        this.startEmbeddedServer = other.startEmbeddedServer;
        String string = this.embeddedServerEndpoint = other.embeddedServerEndpoint != null ? other.embeddedServerEndpoint : DEFAULT_EMBEDDED_SERVER_ENDPOINT;
        if (other.embeddedServerOptions != null) {
            this.embeddedServerOptions = new HttpServerOptions(other.embeddedServerOptions);
        }
        this.publishQuantiles = other.publishQuantiles;
    }

    public VertxPrometheusOptions(JsonObject json) {
        this();
        VertxPrometheusOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        VertxPrometheusOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public VertxPrometheusOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isStartEmbeddedServer() {
        return this.startEmbeddedServer;
    }

    public VertxPrometheusOptions setStartEmbeddedServer(boolean startEmbeddedServer) {
        this.startEmbeddedServer = startEmbeddedServer;
        return this;
    }

    public HttpServerOptions getEmbeddedServerOptions() {
        return this.embeddedServerOptions;
    }

    public VertxPrometheusOptions setEmbeddedServerOptions(HttpServerOptions embeddedServerOptions) {
        this.embeddedServerOptions = embeddedServerOptions;
        return this;
    }

    public VertxPrometheusOptions setEmbeddedServerEndpoint(String embeddedServerEndpoint) {
        this.embeddedServerEndpoint = embeddedServerEndpoint;
        return this;
    }

    public String getEmbeddedServerEndpoint() {
        return this.embeddedServerEndpoint;
    }

    public boolean isPublishQuantiles() {
        return this.publishQuantiles;
    }

    public VertxPrometheusOptions setPublishQuantiles(boolean publishQuantiles) {
        this.publishQuantiles = publishQuantiles;
        return this;
    }
}

