/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.CachedParameterMetaData;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.spi.JDBCColumnDescriptorProvider;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLOptions;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractJDBCAction<T> {
    protected final SQLOptions options;
    protected final JDBCStatementHelper helper;
    private static final JsonArray EMPTY = new JsonArray(Collections.unmodifiableList(new ArrayList()));

    protected AbstractJDBCAction(SQLOptions options) {
        this(null, options);
    }

    protected AbstractJDBCAction(JDBCStatementHelper helper, SQLOptions options) {
        this.options = options;
        this.helper = helper;
    }

    public abstract T execute(Connection var1) throws SQLException;

    protected void applyStatementOptions(Statement statement) throws SQLException {
        if (this.options != null) {
            if (this.options.getQueryTimeout() > 0) {
                statement.setQueryTimeout(this.options.getQueryTimeout());
            }
            if (this.options.getFetchDirection() != null) {
                statement.setFetchDirection(this.options.getFetchDirection().getType());
            }
            if (this.options.getFetchSize() != 0) {
                statement.setFetchSize(this.options.getFetchSize());
            }
            if (this.options.getMaxRows() > 0) {
                statement.setMaxRows(this.options.getMaxRows());
            }
        }
    }

    protected ResultSet asList(java.sql.ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromResultMetaData(rs.getMetaData());
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        ArrayList<JsonArray> results = new ArrayList<JsonArray>();
        while (rs.next()) {
            JsonArray result = new JsonArray();
            for (int i = 1; i <= cols; ++i) {
                Object res = this.helper.getDecoder().parse(rs, i, provider);
                if (res != null) {
                    result.add(res);
                    continue;
                }
                result.addNull();
            }
            results.add(result);
        }
        return new ResultSet(columnNames, results, null);
    }

    protected void fillStatement(PreparedStatement statement, JsonArray in) throws SQLException {
        CachedParameterMetaData md = new CachedParameterMetaData(statement);
        JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromParameterMetaData(md);
        this.fillStatement(statement, in, provider);
    }

    protected void fillStatement(PreparedStatement statement, JsonArray in, JDBCColumnDescriptorProvider provider) throws SQLException {
        if (in == null) {
            in = EMPTY;
        }
        for (int pos = 1; pos <= in.size(); ++pos) {
            statement.setObject(pos, this.helper.getEncoder().encode(in, pos, provider));
        }
    }

    protected void fillStatement(CallableStatement statement, JsonArray in, JsonArray out, JDBCColumnDescriptorProvider provider) throws SQLException {
        if (in == null) {
            in = EMPTY;
        }
        if (out == null) {
            out = EMPTY;
        }
        int max = Math.max(in.size(), out.size());
        for (int i = 0; i < max; ++i) {
            Object value;
            boolean set = false;
            if (i < in.size() && (value = this.helper.getEncoder().encode(in, i + 1, provider)) != null) {
                statement.setObject(i + 1, value);
                set = true;
            }
            value = null;
            if (i < out.size()) {
                value = out.getValue(i);
            }
            if (value != null) {
                if (value instanceof String) {
                    statement.registerOutParameter(i + 1, (int)JDBCType.valueOf((String)value).getVendorTypeNumber());
                } else if (value instanceof Number) {
                    statement.registerOutParameter(i + 1, ((Number)value).intValue());
                }
                set = true;
            }
            if (set) continue;
            statement.setNull(i + 1, 0);
        }
    }
}

