/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi.impl;

import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public class BoneCPDataSourceProvider
implements DataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(BoneCPDataSourceProvider.class);

    private static void mergeConfig(BoneCPConfig config, JsonObject json) {
        for (Map.Entry entry : json) {
            String name = (String)entry.getKey();
            if ("provider_class".equals(name)) continue;
            String mName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
            try {
                Method method = BoneCPConfig.class.getMethod(mName, entry.getValue().getClass());
                method.invoke((Object)config, entry.getValue());
            }
            catch (NoSuchMethodException e) {
                log.warn((Object)("no such property: " + name));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? this.getClass().getClassLoader() : tccl;
    }

    @Override
    public DataSource getDataSource(JsonObject config) throws SQLException {
        BoneCPConfig boneCPConfig = new BoneCPConfig();
        BoneCPDataSourceProvider.mergeConfig(boneCPConfig, config);
        boneCPConfig.setClassLoader(this.getClassLoader());
        return new BoneCPDataSource(boneCPConfig);
    }

    @Override
    public int maximumPoolSize(DataSource dataSource, JsonObject config) {
        if (dataSource instanceof BoneCPDataSource) {
            BoneCPConfig cfg = ((BoneCPDataSource)dataSource).getPool().getConfig();
            return cfg.getMaxConnectionsPerPartition() * cfg.getPartitionCount();
        }
        return -1;
    }

    @Override
    public void close(DataSource dataSource) throws SQLException {
        if (dataSource instanceof BoneCPDataSource) {
            ((BoneCPDataSource)dataSource).close();
        }
    }
}

