/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCSQLRowStream;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLRowStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StreamQuery
extends AbstractJDBCAction<SQLRowStream> {
    private final String sql;
    private final JsonArray in;
    private final int timeout;
    private final int rowStreamFetchSize;

    public StreamQuery(Vertx vertx, JDBCStatementHelper helper, Connection connection, WorkerExecutor exec, int timeout, int rowStreamFetchSize, String sql, JsonArray in) {
        super(vertx, helper, connection, exec);
        this.sql = sql;
        this.in = in;
        this.timeout = timeout;
        this.rowStreamFetchSize = rowStreamFetchSize;
    }

    @Override
    protected SQLRowStream execute() throws SQLException {
        PreparedStatement st = null;
        try {
            st = this.conn.prepareStatement(this.sql);
            if (this.timeout >= 0) {
                st.setQueryTimeout(this.timeout);
            }
            this.helper.fillStatement(st, this.in);
            ResultSet rs = null;
            try {
                rs = st.executeQuery();
                return new JDBCSQLRowStream(this.exec, st, rs, this.rowStreamFetchSize);
            }
            catch (SQLException e) {
                if (rs != null) {
                    rs.close();
                }
                throw e;
            }
        }
        catch (SQLException e) {
            if (st != null) {
                st.close();
            }
            throw e;
        }
    }

    @Override
    protected String name() {
        return "stream";
    }
}

